/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.model.api.spliterator;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashSet;
import java.util.Set;
import java.util.Spliterator;
import java.util.function.Consumer;
import org.eclipse.scout.sdk.core.model.api.IType;
import org.eclipse.scout.sdk.core.util.Ensure;

public class SuperTypeHierarchySpliterator
implements Spliterator<IType> {
    public static final int DEFAULT_CHARACTERISTICS = 1297;
    private final boolean m_includeSuperClasses;
    private final boolean m_includeSuperInterfaces;
    private final boolean m_includeStartType;
    private final int m_characteristics;
    private final Deque<IType> m_dek;
    private final Set<IType> m_visitedSuperInterfaces;
    private final IType m_startType;

    public SuperTypeHierarchySpliterator(IType startType, boolean includeSuperClasses, boolean includeSuperInterfaces, boolean includeStartType) {
        this.m_startType = Ensure.notNull(startType);
        this.m_includeStartType = includeStartType;
        this.m_includeSuperClasses = includeSuperClasses;
        this.m_includeSuperInterfaces = includeSuperInterfaces;
        boolean isSizeKnown = !includeSuperClasses && !includeSuperInterfaces;
        this.m_characteristics = SuperTypeHierarchySpliterator.getCharacteristics(isSizeKnown);
        this.m_dek = isSizeKnown ? new ArrayDeque<IType>(1) : new ArrayDeque<IType>();
        this.m_visitedSuperInterfaces = includeSuperInterfaces ? new HashSet<IType>() : null;
        if (includeStartType) {
            this.m_dek.addLast(startType);
        } else {
            this.enqueueSuperLevelsOf(startType);
        }
    }

    protected static int getCharacteristics(boolean isSizeKnown) {
        int characteristics = 1297;
        if (isSizeKnown) {
            characteristics |= 0x4040;
        }
        return characteristics;
    }

    @Override
    public boolean tryAdvance(Consumer<? super IType> action) {
        this.moveToNextValidElement();
        if (!this.isDataAvailable()) {
            return false;
        }
        this.consumeNext(action);
        return true;
    }

    protected void consumeNext(Consumer<? super IType> action) {
        action.accept(this.moveToNext());
    }

    protected void moveToNextValidElement() {
        while (this.isDataAvailable()) {
            boolean selfAccepted;
            IType next = this.m_dek.peekFirst();
            boolean ifcAccepted = this.isIncludeSuperInterfaces() && next.isInterface();
            boolean superClassAccepted = this.isIncludeSuperClasses() && !next.isInterface();
            boolean bl = selfAccepted = this.isIncludeStartType() && next == this.m_startType;
            if (ifcAccepted || superClassAccepted || selfAccepted) {
                return;
            }
            this.moveToNext();
        }
    }

    protected boolean isDataAvailable() {
        return !this.m_dek.isEmpty();
    }

    protected IType moveToNext() {
        IType curElement = this.m_dek.removeFirst();
        this.enqueueSuperLevelsOf(curElement);
        return curElement;
    }

    protected void enqueueSuperLevelsOf(IType curLevel) {
        if (!curLevel.isInterface()) {
            curLevel.superClass().ifPresent(this.m_dek::addLast);
        }
        if (!this.isIncludeSuperInterfaces()) {
            return;
        }
        curLevel.superInterfaces().filter(this.m_visitedSuperInterfaces::add).forEach(this.m_dek::addLast);
    }

    @Override
    public Spliterator<IType> trySplit() {
        return null;
    }

    @Override
    public long estimateSize() {
        if (this.hasCharacteristics(64)) {
            if (this.isIncludeStartType()) {
                return 1L;
            }
            return 0L;
        }
        return Long.MAX_VALUE;
    }

    @Override
    public int characteristics() {
        return this.m_characteristics;
    }

    protected boolean isIncludeSuperClasses() {
        return this.m_includeSuperClasses;
    }

    protected boolean isIncludeSuperInterfaces() {
        return this.m_includeSuperInterfaces;
    }

    protected boolean isIncludeStartType() {
        return this.m_includeStartType;
    }
}

