/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.model.api.spliterator;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Spliterator;
import java.util.function.Consumer;
import org.eclipse.scout.sdk.core.model.api.IType;
import org.eclipse.scout.sdk.core.model.api.spliterator.SuperTypeHierarchySpliterator;
import org.eclipse.scout.sdk.core.model.api.spliterator.WrappingSpliterator;
import org.eclipse.scout.sdk.core.util.Ensure;

public class InnerTypeSpliterator
implements Spliterator<IType> {
    private final boolean m_includeInnerTypesRecursive;
    private final int m_characteristics;
    private final Deque<IType> m_dek;
    private Spliterator<IType> m_innerTypes;

    public InnerTypeSpliterator(IType innerTypeHolder, boolean includeInnerTypesRecursive) {
        this(InnerTypeSpliterator.innerTypesOf(Ensure.notNull(innerTypeHolder)), includeInnerTypesRecursive);
    }

    public InnerTypeSpliterator(Spliterator<IType> innerTypesFirstLevel, boolean includeInnerTypesRecursive) {
        this.m_includeInnerTypesRecursive = includeInnerTypesRecursive;
        this.m_characteristics = SuperTypeHierarchySpliterator.getCharacteristics(!includeInnerTypesRecursive);
        this.m_dek = includeInnerTypesRecursive ? new ArrayDeque<IType>() : null;
        this.m_innerTypes = innerTypesFirstLevel;
    }

    public static Spliterator<IType> innerTypesOf(IType focusType) {
        return new WrappingSpliterator<IType>(focusType.unwrap().getTypes());
    }

    @Override
    public boolean tryAdvance(Consumer<? super IType> action) {
        boolean consumed = this.consume(action);
        if (this.isIncludeInnerTypesRecursive()) {
            while (!consumed && this.tryMoveToNextInnerType()) {
                consumed = this.consume(action);
            }
        }
        return consumed;
    }

    protected boolean tryMoveToNextInnerType() {
        if (this.m_dek.isEmpty()) {
            return false;
        }
        this.moveToInnerTypesOf(this.m_dek.removeFirst());
        return true;
    }

    protected void moveToInnerTypesOf(IType newFocusType) {
        this.m_innerTypes = InnerTypeSpliterator.innerTypesOf(newFocusType);
    }

    protected boolean consume(Consumer<? super IType> action) {
        return this.m_innerTypes.tryAdvance((? super T t) -> {
            if (this.isIncludeInnerTypesRecursive()) {
                this.m_dek.addLast((IType)t);
            }
            action.accept((IType)t);
        });
    }

    @Override
    public Spliterator<IType> trySplit() {
        return null;
    }

    @Override
    public long estimateSize() {
        if (this.hasCharacteristics(64)) {
            return this.m_innerTypes.estimateSize();
        }
        return Long.MAX_VALUE;
    }

    @Override
    public int characteristics() {
        return this.m_characteristics;
    }

    public boolean isIncludeInnerTypesRecursive() {
        return this.m_includeInnerTypesRecursive;
    }
}

