/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.model.api.spliterator;

import java.util.Spliterator;
import java.util.function.Function;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.eclipse.scout.sdk.core.model.api.IType;
import org.eclipse.scout.sdk.core.model.api.spliterator.HierarchicalSpliterator;
import org.eclipse.scout.sdk.core.util.Ensure;

public class HierarchicalStreamBuilder<ELEMENT> {
    private boolean m_includeSuperClasses;
    private boolean m_includeSuperInterfaces;
    private boolean m_includeStartType;

    protected boolean isIncludeSuperClasses() {
        return this.m_includeSuperClasses;
    }

    public HierarchicalStreamBuilder<ELEMENT> withSuperClasses(boolean includeSuperClasses) {
        this.m_includeSuperClasses = includeSuperClasses;
        return this;
    }

    protected boolean isIncludeSuperInterfaces() {
        return this.m_includeSuperInterfaces;
    }

    public HierarchicalStreamBuilder<ELEMENT> withSuperInterfaces(boolean includeSuperInterfaces) {
        this.m_includeSuperInterfaces = includeSuperInterfaces;
        return this;
    }

    protected boolean isIncludeStartType() {
        return this.m_includeStartType;
    }

    public HierarchicalStreamBuilder<ELEMENT> withStartType(boolean includeStartType) {
        this.m_includeStartType = includeStartType;
        return this;
    }

    public Stream<ELEMENT> build(IType startType, Function<IType, Spliterator<ELEMENT>> levelSpliteratorProvider) {
        return StreamSupport.stream(new HierarchicalSpliterator<ELEMENT>(Ensure.notNull(startType), this.isIncludeSuperClasses(), this.isIncludeSuperInterfaces(), this.isIncludeStartType(), Ensure.notNull(levelSpliteratorProvider)), false);
    }
}

