/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.model.api.query;

import java.util.stream.Stream;
import org.eclipse.scout.sdk.core.model.api.IType;
import org.eclipse.scout.sdk.core.model.api.query.AbstractInnerTypeQuery;
import org.eclipse.scout.sdk.core.model.api.spliterator.HierarchicalStreamBuilder;
import org.eclipse.scout.sdk.core.model.api.spliterator.InnerTypeSpliterator;

public class HierarchyInnerTypeQuery
extends AbstractInnerTypeQuery<HierarchyInnerTypeQuery> {
    private final IType m_ownerType;
    private boolean m_includeSuperClasses;

    public HierarchyInnerTypeQuery(IType owner) {
        super(InnerTypeSpliterator.innerTypesOf(owner));
        this.m_ownerType = owner;
    }

    protected IType getOwnerType() {
        return this.m_ownerType;
    }

    public HierarchyInnerTypeQuery withSuperClasses(boolean b) {
        this.m_includeSuperClasses = b;
        return this;
    }

    public boolean isIncludeSuperClasses() {
        return this.m_includeSuperClasses;
    }

    @Override
    protected Stream<IType> createStream() {
        if (this.isIncludeSuperClasses()) {
            return new HierarchicalStreamBuilder().withSuperClasses(true).withStartType(true).build(this.getOwnerType(), level -> new InnerTypeSpliterator((IType)level, this.isIncludeRecursiveInnerTypes()));
        }
        return super.createStream();
    }
}

