/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.model.api.internal;

import java.util.Optional;
import java.util.stream.Stream;
import org.eclipse.scout.sdk.core.generator.SimpleGenerators;
import org.eclipse.scout.sdk.core.generator.type.ITypeGenerator;
import org.eclipse.scout.sdk.core.model.api.IBreadthFirstJavaElementVisitor;
import org.eclipse.scout.sdk.core.model.api.ICompilationUnit;
import org.eclipse.scout.sdk.core.model.api.IDepthFirstJavaElementVisitor;
import org.eclipse.scout.sdk.core.model.api.IJavaElement;
import org.eclipse.scout.sdk.core.model.api.IPackage;
import org.eclipse.scout.sdk.core.model.api.ISourceRange;
import org.eclipse.scout.sdk.core.model.api.IType;
import org.eclipse.scout.sdk.core.model.api.IUnresolvedType;
import org.eclipse.scout.sdk.core.model.api.internal.AbstractJavaElementImplementor;
import org.eclipse.scout.sdk.core.model.spi.AbstractSpiElement;
import org.eclipse.scout.sdk.core.model.spi.JavaElementSpi;
import org.eclipse.scout.sdk.core.model.spi.JavaEnvironmentSpi;
import org.eclipse.scout.sdk.core.transformer.IWorkingCopyTransformer;
import org.eclipse.scout.sdk.core.util.visitor.TreeVisitResult;

public class UnresolvedTypeImplementor
extends AbstractJavaElementImplementor<UnresolvedTypeSpi>
implements IUnresolvedType {
    UnresolvedTypeImplementor(UnresolvedTypeSpi spi) {
        super(spi);
    }

    @Override
    public String name() {
        return ((UnresolvedTypeSpi)this.m_spi).getName();
    }

    @Override
    public IPackage containingPackage() {
        return ((UnresolvedTypeSpi)this.m_spi).getPackage();
    }

    @Override
    public String reference() {
        return this.name();
    }

    @Override
    public boolean exists() {
        return this.type().isPresent();
    }

    @Override
    public Optional<IType> type() {
        return Optional.ofNullable(((UnresolvedTypeSpi)this.m_spi).getType());
    }

    @Override
    public Stream<? extends IJavaElement> children() {
        return this.type().map(IJavaElement::children).orElseGet(Stream::empty);
    }

    @Override
    public ITypeGenerator<?> toWorkingCopy(IWorkingCopyTransformer transformer) {
        return SimpleGenerators.createUnresolvedTypeGenerator(this, transformer);
    }

    @Override
    public ITypeGenerator<?> toWorkingCopy() {
        return this.toWorkingCopy(null);
    }

    public static final class UnresolvedTypeSpi
    extends AbstractSpiElement<IUnresolvedType>
    implements JavaElementSpi {
        private final IType m_type;
        private final String m_name;
        private final IPackage m_package;
        private final String m_simpleName;

        public UnresolvedTypeSpi(JavaEnvironmentSpi env, IType type) {
            super(env);
            this.m_type = type;
            this.m_name = type.name();
            this.m_package = type.compilationUnit().map(ICompilationUnit::containingPackage).orElseGet(() -> env.getPackage(null).wrap());
            this.m_simpleName = type.elementName();
        }

        public UnresolvedTypeSpi(JavaEnvironmentSpi env, String name) {
            super(env);
            this.m_type = null;
            this.m_name = name;
            int dot = name.lastIndexOf(46);
            if (dot > 0) {
                this.m_package = env.getPackage(name.substring(0, dot)).wrap();
                this.m_simpleName = name.substring(dot + 1);
            } else {
                this.m_package = env.getPackage(null).wrap();
                this.m_simpleName = name;
            }
        }

        @Override
        public String getElementName() {
            return this.m_simpleName;
        }

        @Override
        public ISourceRange getSource() {
            if (this.m_type == null) {
                return null;
            }
            return this.m_type.unwrap().getSource();
        }

        public IPackage getPackage() {
            return this.m_package;
        }

        public String getName() {
            return this.m_name;
        }

        public IType getType() {
            return this.m_type;
        }

        @Override
        public TreeVisitResult acceptPreOrder(IDepthFirstJavaElementVisitor visitor, int level, int index) {
            return visitor.preVisit((IUnresolvedType)this.wrap(), level, index);
        }

        @Override
        public boolean acceptPostOrder(IDepthFirstJavaElementVisitor visitor, int level, int index) {
            return visitor.postVisit((IUnresolvedType)this.wrap(), level, index);
        }

        @Override
        public TreeVisitResult acceptLevelOrder(IBreadthFirstJavaElementVisitor visitor, int level, int index) {
            return visitor.visit((IUnresolvedType)this.wrap(), level, index);
        }

        @Override
        protected IUnresolvedType internalCreateApi() {
            return new UnresolvedTypeImplementor(this);
        }

        @Override
        public JavaElementSpi internalFindNewElement() {
            return null;
        }
    }
}

