/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.model.api;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.function.Function;
import java.util.function.Supplier;
import org.eclipse.scout.sdk.core.apidef.ApiFunction;
import org.eclipse.scout.sdk.core.apidef.IApiSpecification;
import org.eclipse.scout.sdk.core.apidef.ITypeNameSupplier;
import org.eclipse.scout.sdk.core.model.api.IAnnotation;
import org.eclipse.scout.sdk.core.model.api.IAnnotationElement;
import org.eclipse.scout.sdk.core.model.api.IField;
import org.eclipse.scout.sdk.core.util.Ensure;
import org.eclipse.scout.sdk.core.util.SdkException;

public abstract class AbstractManagedAnnotation {
    protected static final String TYPE_NAME_FIELD_NAME = "TYPE_NAME";
    private IAnnotation m_ann;

    protected AbstractManagedAnnotation() {
    }

    public static <A extends AbstractManagedAnnotation> A wrap(IAnnotation a, Class<A> managedAnnotationType) {
        try {
            AbstractManagedAnnotation annotation = (AbstractManagedAnnotation)managedAnnotationType.getConstructor(new Class[0]).newInstance(new Object[0]);
            annotation.postConstruct(a);
            return (A)annotation;
        }
        catch (ReflectiveOperationException e) {
            throw new IllegalArgumentException("create " + managedAnnotationType.getName() + " with " + a, e);
        }
    }

    public static ApiFunction<?, ITypeNameSupplier> typeName(Class<? extends AbstractManagedAnnotation> a) {
        if (a == null) {
            return null;
        }
        try {
            Field field = a.getDeclaredField(TYPE_NAME_FIELD_NAME);
            field.setAccessible(true);
            return Ensure.instanceOf(field.get(null), ApiFunction.class);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
            throw new SdkException((CharSequence)"Failed to read field {} of {}. Each managed annotation must define its {} using a field called '{}' of type {}.", TYPE_NAME_FIELD_NAME, a, ITypeNameSupplier.class.getSimpleName(), TYPE_NAME_FIELD_NAME, e, ApiFunction.class.getSimpleName());
        }
    }

    protected void postConstruct(IAnnotation ann) {
        this.m_ann = ann;
    }

    protected <A extends IApiSpecification> String getNameFromApi(Class<A> apiDefinition, Function<A, String> nameSupplier) {
        IApiSpecification api = (IApiSpecification)Ensure.notNull(this.m_ann.javaEnvironment().requireApi(apiDefinition));
        return Ensure.notBlank(nameSupplier.apply(api));
    }

    protected <A extends IApiSpecification, T> T getValueFrom(Class<A> apiDefinition, Function<A, String> nameSupplier, Class<T> expectedType, Supplier<T> optionalCustomDefaultValueSupplier) {
        String name = this.getNameFromApi(apiDefinition, nameSupplier);
        return this.getValue(name, expectedType, optionalCustomDefaultValueSupplier);
    }

    protected <T> T getValue(String name, Class<T> expectedType, Supplier<T> optionalCustomDefaultValueSupplier) {
        IAnnotationElement av = this.m_ann.element(name).orElseThrow(() -> this.elementNotExistingException(name));
        if (optionalCustomDefaultValueSupplier != null && av.isDefault()) {
            return optionalCustomDefaultValueSupplier.get();
        }
        if (expectedType.isArray() && AbstractManagedAnnotation.class.isAssignableFrom(expectedType.getComponentType())) {
            IAnnotation[] a = av.value().as(IAnnotation[].class);
            Class<?> componentType = expectedType.getComponentType();
            Object array = Array.newInstance(componentType, a.length);
            for (int i = 0; i < a.length; ++i) {
                Array.set(array, i, a[i].wrap(componentType));
            }
            return (T)array;
        }
        if (AbstractManagedAnnotation.class.isAssignableFrom(expectedType)) {
            Class<T> xType = expectedType;
            return av.value().as(IAnnotation.class).wrap(xType);
        }
        return av.value().as(expectedType);
    }

    protected <A extends IApiSpecification, T extends Enum<T>> T getValueAsEnumFrom(Class<A> apiDefinition, Function<A, String> nameSupplier, Class<T> enumType) {
        return this.getValueAsEnumFrom(apiDefinition, nameSupplier, enumType, null);
    }

    protected <A extends IApiSpecification, T extends Enum<T>> T getValueAsEnumFrom(Class<A> apiDefinition, Function<A, String> nameSupplier, Class<T> enumType, Supplier<T> optionalCustomDefaultValueSupplier) {
        String name = this.getNameFromApi(apiDefinition, nameSupplier);
        return this.getValueAsEnum(name, enumType, optionalCustomDefaultValueSupplier);
    }

    protected <T extends Enum<T>> T getValueAsEnum(String elementName, Class<T> enumType) {
        return this.getValueAsEnum(elementName, enumType, null);
    }

    protected <T extends Enum<T>> T getValueAsEnum(String elementName, Class<T> enumType, Supplier<T> optionalCustomDefaultValueSupplier) {
        if (optionalCustomDefaultValueSupplier != null && this.isDefault(elementName)) {
            return (T)((Enum)optionalCustomDefaultValueSupplier.get());
        }
        IField enumValueField = this.getValue(elementName, IField.class, null);
        if (enumValueField == null) {
            throw this.elementNotExistingException(elementName);
        }
        return Enum.valueOf(enumType, enumValueField.elementName());
    }

    protected SdkException elementNotExistingException(String name) {
        return new SdkException((CharSequence)"Annotation '{}' has no attribute named '{}'.", this.m_ann.elementName(), name);
    }

    protected boolean isDefault(String name) {
        return this.m_ann.element(name).map(IAnnotationElement::isDefault).orElseThrow(() -> this.elementNotExistingException(name));
    }

    protected <A extends IApiSpecification> boolean isDefault(Class<A> apiDefinition, Function<A, String> nameSupplier) {
        return this.isDefault(this.getNameFromApi(apiDefinition, nameSupplier));
    }

    public IAnnotation unwrap() {
        return this.m_ann;
    }
}

