/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.model;

import java.nio.file.Path;
import java.util.Objects;
import org.eclipse.scout.sdk.core.generator.compilationunit.ICompilationUnitGenerator;
import org.eclipse.scout.sdk.core.model.CompilationUnitInfo;
import org.eclipse.scout.sdk.core.model.api.IClasspathEntry;
import org.eclipse.scout.sdk.core.util.Ensure;

public class CompilationUnitInfoWithClasspath
extends CompilationUnitInfo {
    private final IClasspathEntry m_cpEntry;

    public CompilationUnitInfoWithClasspath(IClasspathEntry sourceFolder, Path sourceFolderRelPath) {
        super(sourceFolder == null ? null : sourceFolder.path(), sourceFolderRelPath);
        this.m_cpEntry = sourceFolder;
    }

    public CompilationUnitInfoWithClasspath(IClasspathEntry sourceFolder, String packageName, String fileName) {
        super(sourceFolder == null ? null : sourceFolder.path(), packageName, fileName);
        this.m_cpEntry = sourceFolder;
    }

    public CompilationUnitInfoWithClasspath(IClasspathEntry sourceFolder, ICompilationUnitGenerator<?> generator) {
        this(sourceFolder, (String)generator.packageName().orElse(null), generator.fileName().orElseThrow(() -> Ensure.newFail("File name missing in generator", new Object[0])));
    }

    public IClasspathEntry classpathEntry() {
        return this.m_cpEntry;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        CompilationUnitInfoWithClasspath that = (CompilationUnitInfoWithClasspath)o;
        return Objects.equals(this.m_cpEntry, that.m_cpEntry);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.m_cpEntry);
    }
}

