/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.imports;

import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.scout.sdk.core.builder.java.IJavaBuilderContext;
import org.eclipse.scout.sdk.core.generator.type.ITypeGenerator;
import org.eclipse.scout.sdk.core.imports.IImportCollector;
import org.eclipse.scout.sdk.core.imports.TypeReferenceDescriptor;
import org.eclipse.scout.sdk.core.imports.WrappedImportCollector;
import org.eclipse.scout.sdk.core.model.api.Flags;
import org.eclipse.scout.sdk.core.model.api.IJavaEnvironment;
import org.eclipse.scout.sdk.core.model.api.IType;
import org.eclipse.scout.sdk.core.model.api.query.AbstractInnerTypeQuery;
import org.eclipse.scout.sdk.core.model.api.query.AbstractQuery;
import org.eclipse.scout.sdk.core.util.JavaTypes;

public class EnclosingTypeScopedImportCollector
extends WrappedImportCollector {
    private final String m_qualifier;
    private final Set<String> m_visibleInnerTypeInSuperHierarchyNames;
    private final Set<String> m_innerTypeSimpleNames;

    public EnclosingTypeScopedImportCollector(IImportCollector inner, ITypeGenerator<?> enclosingTypeGenerator) {
        super(inner);
        this.m_qualifier = enclosingTypeGenerator.fullyQualifiedName();
        this.m_innerTypeSimpleNames = enclosingTypeGenerator.types().map(t -> t.elementName(this.getContext().orElse(null))).flatMap(Optional::stream).collect(Collectors.toSet());
        IJavaBuilderContext context = this.getContext().orElse(null);
        if (context == null) {
            this.m_visibleInnerTypeInSuperHierarchyNames = Collections.emptySet();
            return;
        }
        IJavaEnvironment env = this.getJavaEnvironment().orElse(null);
        if (env == null) {
            this.m_visibleInnerTypeInSuperHierarchyNames = Collections.emptySet();
            return;
        }
        this.m_visibleInnerTypeInSuperHierarchyNames = Stream.concat(enclosingTypeGenerator.superClassFunc().stream(), enclosingTypeGenerator.interfacesFunc()).map(af -> (String)af.apply(context)).map(JavaTypes::erasure).map(env::findType).flatMap(Optional::stream).map(IType::superTypes).flatMap(AbstractQuery::stream).filter(s -> !Object.class.getName().equals(s.name())).map(IType::innerTypes).flatMap(AbstractInnerTypeQuery::stream).filter(t -> !Flags.isPrivate(t.flags())).map(IType::name).map(s -> s.replace('$', '.')).collect(Collectors.toSet());
    }

    @Override
    public String getQualifier() {
        return this.m_qualifier;
    }

    @Override
    public String checkCurrentScope(TypeReferenceDescriptor descriptor) {
        if (this.m_qualifier.equals(descriptor.getQualifiedName())) {
            return descriptor.getSimpleName();
        }
        if (this.m_innerTypeSimpleNames.contains(descriptor.getSimpleName())) {
            if (this.m_qualifier.equals(descriptor.getQualifier())) {
                return descriptor.getSimpleName();
            }
            return descriptor.getQualifiedName();
        }
        if (this.m_visibleInnerTypeInSuperHierarchyNames.contains(descriptor.getQualifiedName())) {
            return descriptor.getSimpleName();
        }
        return super.checkCurrentScope(descriptor);
    }
}

