/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.imports;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import org.eclipse.scout.sdk.core.generator.compilationunit.ICompilationUnitGenerator;
import org.eclipse.scout.sdk.core.generator.type.ITypeGenerator;
import org.eclipse.scout.sdk.core.imports.IImportCollector;
import org.eclipse.scout.sdk.core.imports.TypeReferenceDescriptor;
import org.eclipse.scout.sdk.core.imports.WrappedImportCollector;
import org.eclipse.scout.sdk.core.model.api.IJavaEnvironment;
import org.eclipse.scout.sdk.core.util.Strings;

public class CompilationUnitScopedImportCollector
extends WrappedImportCollector {
    private final String m_packageName;
    private final Map<String, Boolean> m_existsInSamePackageCache = new HashMap<String, Boolean>();

    public CompilationUnitScopedImportCollector(IImportCollector inner, String packageName) {
        this(inner, packageName, null);
    }

    public CompilationUnitScopedImportCollector(IImportCollector inner, String packageName, ICompilationUnitGenerator<?> cuGenerator) {
        super(inner);
        this.m_packageName = packageName;
        if (cuGenerator != null) {
            this.consumeAllTypeNamesRec(cuGenerator.types());
            this.registerImports(cuGenerator);
        }
    }

    protected void registerImports(ICompilationUnitGenerator<?> cuGenerator) {
        cuGenerator.imports().forEach(this::addImport);
        cuGenerator.staticImports().forEach(this::addStaticImport);
    }

    protected void consumeAllTypeNamesRec(Stream<ITypeGenerator<?>> stream) {
        stream.peek(g -> this.consumeAllTypeNamesRec(g.types())).map(ITypeGenerator::fullyQualifiedName).map(TypeReferenceDescriptor::new).forEach(this::reserveElement);
    }

    @Override
    public String getQualifier() {
        return this.m_packageName;
    }

    @Override
    public String checkCurrentScope(TypeReferenceDescriptor cand) {
        String q = this.getQualifier();
        if (Objects.equals(q, cand.getQualifier()) || Strings.isBlank(q) && Strings.isBlank(cand.getQualifier())) {
            return cand.getSimpleName();
        }
        IJavaEnvironment env = this.getJavaEnvironment().orElse(null);
        if (env == null) {
            return super.checkCurrentScope(cand);
        }
        boolean existsInSamePackage = this.m_existsInSamePackageCache.computeIfAbsent(cand.getSimpleName(), simpleName -> env.exists(Strings.isEmpty(q) ? simpleName : new StringBuilder((CharSequence)q).append('.').append((String)simpleName).toString()));
        if (existsInSamePackage) {
            return cand.getQualifiedName();
        }
        return super.checkCurrentScope(cand);
    }
}

