/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.generator.type;

import java.util.concurrent.atomic.AtomicLong;
import org.eclipse.scout.sdk.core.generator.field.IFieldGenerator;
import org.eclipse.scout.sdk.core.generator.member.IMemberGenerator;
import org.eclipse.scout.sdk.core.generator.method.IMethodGenerator;
import org.eclipse.scout.sdk.core.generator.type.ITypeGenerator;
import org.eclipse.scout.sdk.core.model.api.Flags;
import org.eclipse.scout.sdk.core.model.api.IJavaElement;
import org.eclipse.scout.sdk.core.util.CompositeObject;
import org.eclipse.scout.sdk.core.util.Ensure;
import org.eclipse.scout.sdk.core.util.FinalValue;

public class SortedMemberEntry
implements Comparable<SortedMemberEntry> {
    public static final int PARSED_ORDER = 10;
    public static final int DEFAULT_ORDER = 20;
    public static final int FIELD_ORDER = 100000;
    public static final int METHOD_ORDER = 200000;
    public static final int TYPE_ORDER = 300000;
    private static final AtomicLong INPUT_ORDER = new AtomicLong();
    private final IMemberGenerator<?> m_generator;
    private final FinalValue<CompositeObject> m_sortOrder;
    private final long m_index;

    public SortedMemberEntry(IMemberGenerator<?> generator, IJavaElement origin) {
        Object[] objectArray = new Object[2];
        objectArray[0] = 10;
        objectArray[1] = origin.source().map(range -> range.start()).orElseGet(INPUT_ORDER::getAndIncrement);
        this(generator, objectArray);
    }

    public SortedMemberEntry(IMemberGenerator<?> generator) {
        this(generator, (Object[])null);
    }

    public SortedMemberEntry(IMemberGenerator<?> generator, Object ... sortOrder) {
        this.m_generator = Ensure.notNull(generator);
        this.m_sortOrder = new FinalValue();
        if (sortOrder != null && sortOrder.length > 0) {
            this.m_sortOrder.set(new CompositeObject(sortOrder));
            this.m_index = 0L;
        } else {
            this.m_index = INPUT_ORDER.getAndIncrement();
        }
    }

    public IMemberGenerator<?> generator() {
        return this.m_generator;
    }

    public CompositeObject sortOrder() {
        return this.m_sortOrder.computeIfAbsentAndGet(this::calculateDefaultOrder);
    }

    protected CompositeObject calculateDefaultOrder() {
        IMemberGenerator<?> generator = this.generator();
        if (this.isType()) {
            return SortedMemberEntry.defaultTypeOrder((ITypeGenerator)generator, this.m_index);
        }
        if (this.isMethod()) {
            return SortedMemberEntry.defaultMethodOrder((IMethodGenerator)generator, this.m_index);
        }
        return SortedMemberEntry.defaultFieldOrder((IFieldGenerator)generator, this.m_index);
    }

    public boolean isMethod() {
        return this.hasType(IMethodGenerator.class);
    }

    public boolean isType() {
        return this.hasType(ITypeGenerator.class);
    }

    public boolean isField() {
        return this.hasType(IFieldGenerator.class);
    }

    public boolean hasType(Class<?> type) {
        return type.isAssignableFrom(this.generator().getClass());
    }

    @Override
    public int compareTo(SortedMemberEntry o) {
        return this.sortOrder().compareTo(o.sortOrder());
    }

    public int hashCode() {
        return this.sortOrder().hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        SortedMemberEntry other = (SortedMemberEntry)obj;
        return this.sortOrder().equals(other.sortOrder());
    }

    protected static CompositeObject defaultFieldOrder(IFieldGenerator<?> generator, long insertionOrder) {
        boolean isSerialVersionUid;
        int flags = generator.flags();
        boolean isFinal = Flags.isFinal(flags);
        boolean isConstant = Flags.isStatic(flags) && isFinal;
        boolean bl = isSerialVersionUid = isConstant && Flags.isPrivate(flags) && "serialVersionUID".equals(generator.elementName().orElse(null));
        int pos = isSerialVersionUid ? 1000 : (isConstant ? 2000 : (isFinal ? 3000 : 4000));
        return new CompositeObject(20, 100000, pos, insertionOrder);
    }

    protected static CompositeObject defaultTypeOrder(ITypeGenerator<?> generator, long insertionOrder) {
        int flags = generator.flags();
        int pos = Flags.isPublic(flags) ? 1000 : (Flags.isStatic(flags) ? 3000 : 2000);
        return new CompositeObject(20, 300000, pos, insertionOrder);
    }

    protected static CompositeObject defaultMethodOrder(IMethodGenerator<?, ?> generator, long insertionOrder) {
        int pos = generator.isConstructor() ? 1000 : (Flags.isStatic(generator.flags()) ? 3000 : 4000);
        return new CompositeObject(20, 200000, pos, insertionOrder);
    }

    public static Object[] createDefaultMethodPos(Object ... order) {
        return SortedMemberEntry.combine(200000, order);
    }

    public static Object[] createDefaultTypePos(Object ... order) {
        return SortedMemberEntry.combine(300000, order);
    }

    public static Object[] createDefaultFieldPos(Object ... order) {
        return SortedMemberEntry.combine(100000, order);
    }

    static Object[] combine(int objectOrder, Object ... orders) {
        if (orders == null || orders.length < 1) {
            return new Object[]{20, objectOrder};
        }
        Object[] result = new Object[orders.length + 2];
        result[0] = 20;
        result[1] = objectOrder;
        System.arraycopy(orders, 0, result, 2, orders.length);
        return result;
    }
}

