/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.generator.type;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.eclipse.scout.sdk.core.apidef.IApiSpecification;
import org.eclipse.scout.sdk.core.builder.ISourceBuilder;
import org.eclipse.scout.sdk.core.builder.java.IJavaBuilderContext;
import org.eclipse.scout.sdk.core.builder.java.JavaBuilderContextFunction;
import org.eclipse.scout.sdk.core.builder.java.comment.ICommentBuilder;
import org.eclipse.scout.sdk.core.builder.java.comment.IJavaElementCommentBuilder;
import org.eclipse.scout.sdk.core.generator.AbstractJavaElementGenerator;
import org.eclipse.scout.sdk.core.generator.IJavaElementGenerator;
import org.eclipse.scout.sdk.core.generator.ISourceGenerator;
import org.eclipse.scout.sdk.core.generator.PackageGenerator;
import org.eclipse.scout.sdk.core.generator.annotation.IAnnotationGenerator;
import org.eclipse.scout.sdk.core.generator.compilationunit.CompilationUnitGenerator;
import org.eclipse.scout.sdk.core.generator.compilationunit.ICompilationUnitGenerator;
import org.eclipse.scout.sdk.core.generator.field.IFieldGenerator;
import org.eclipse.scout.sdk.core.generator.method.IMethodGenerator;
import org.eclipse.scout.sdk.core.generator.type.ITypeGenerator;
import org.eclipse.scout.sdk.core.generator.type.TypeGenerator;
import org.eclipse.scout.sdk.core.generator.typeparam.ITypeParameterGenerator;
import org.eclipse.scout.sdk.core.model.api.IType;
import org.eclipse.scout.sdk.core.transformer.IWorkingCopyTransformer;
import org.eclipse.scout.sdk.core.util.Ensure;

public class PrimaryTypeGenerator<TYPE extends PrimaryTypeGenerator<TYPE>>
implements ITypeGenerator<TYPE>,
ICompilationUnitGenerator<TYPE> {
    private final ITypeGenerator<?> m_primaryType;
    private final ICompilationUnitGenerator<?> m_compilationUnit;
    private final List<BiConsumer<TYPE, IJavaBuilderContext>> m_buildPreProcessors = new ArrayList<BiConsumer<TYPE, IJavaBuilderContext>>();
    private boolean m_setupDone;

    protected PrimaryTypeGenerator() {
        this.m_primaryType = (ITypeGenerator)((ITypeGenerator)new TypeGenerator().asPublic()).withComment(IJavaElementCommentBuilder::appendDefaultElementComment);
        this.m_compilationUnit = ((ICompilationUnitGenerator)CompilationUnitGenerator.create().withComment(IJavaElementCommentBuilder::appendDefaultElementComment)).withType(this.m_primaryType, new Object[0]);
    }

    public static PrimaryTypeGenerator<?> create() {
        return new PrimaryTypeGenerator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void generate(ISourceBuilder<?> builder) {
        if (!this.isSetupDone()) {
            this.setup();
            this.setSetupDone();
        }
        this.preProcessors().forEach(c -> c.accept(this, AbstractJavaElementGenerator.ensureJavaSourceBuilder(builder).context()));
        ICompilationUnitGenerator<?> templateCu = this.compilationUnit();
        ITypeGenerator<?> templateType = this.primaryType();
        templateCu.withoutType((ITypeGenerator<?> t) -> t == templateType);
        try {
            Object currentCu = ((ICompilationUnitGenerator)((ICompilationUnitGenerator)CompilationUnitGenerator.create().withComment(templateCu.comment().orElse(null))).withElementNameFunc((Function<IJavaBuilderContext, String>)templateCu.elementNameFunc().orElseThrow(() -> Ensure.newFail("Type name is missing.", new Object[0])))).withPackage(this.getPackage().orElse(null)).withType(templateType, new Object[0]);
            templateCu.imports().forEach(arg_0 -> currentCu.withImport(arg_0));
            templateCu.staticImports().forEach(arg_0 -> currentCu.withStaticImport(arg_0));
            templateCu.footers().forEach(arg_0 -> currentCu.withFooter(arg_0));
            currentCu.generate(builder);
        }
        finally {
            templateCu.withType(templateType, new Object[0]);
        }
    }

    protected void setup() {
    }

    private ITypeGenerator<?> primaryType() {
        return this.m_primaryType;
    }

    private ICompilationUnitGenerator<?> compilationUnit() {
        return this.m_compilationUnit;
    }

    @Override
    public Stream<BiConsumer<TYPE, IJavaBuilderContext>> preProcessors() {
        return this.m_buildPreProcessors.stream();
    }

    @Override
    public TYPE withPreProcessor(BiConsumer<TYPE, IJavaBuilderContext> processor) {
        if (processor != null) {
            this.m_buildPreProcessors.add(processor);
        }
        return this.thisInstance();
    }

    protected TYPE thisInstance() {
        return (TYPE)this;
    }

    @Override
    public Optional<ITypeGenerator<?>> mainType() {
        return Optional.of(this.primaryType());
    }

    @Override
    public Optional<String> fileName() {
        return this.compilationUnit().fileName();
    }

    @Override
    public Optional<PackageGenerator> getPackage() {
        return this.compilationUnit().getPackage();
    }

    @Override
    public Optional<String> packageName() {
        return this.compilationUnit().packageName();
    }

    @Override
    public TYPE withPackageName(String newPackage) {
        this.compilationUnit().withPackageName(newPackage);
        this.setDeclaringFullyQualifiedName(newPackage);
        return this.thisInstance();
    }

    @Override
    public TYPE withPackage(PackageGenerator generator) {
        this.compilationUnit().withPackage(generator);
        if (generator == null) {
            this.setDeclaringFullyQualifiedName(null);
        } else {
            this.setDeclaringFullyQualifiedName(generator.elementName().orElse(null));
        }
        return this.thisInstance();
    }

    @Override
    public TYPE withFlags(int flags) {
        this.primaryType().withFlags(flags);
        return this.thisInstance();
    }

    @Override
    public int flags() {
        return this.primaryType().flags();
    }

    @Override
    public TYPE withoutFlags(int flags) {
        this.primaryType().withoutFlags(flags);
        return this.thisInstance();
    }

    @Override
    public TYPE asPublic() {
        this.primaryType().asPublic();
        return this.thisInstance();
    }

    @Override
    public TYPE asAbstract() {
        this.primaryType().asAbstract();
        return this.thisInstance();
    }

    @Override
    public TYPE asPrivate() {
        this.primaryType().asPrivate();
        return this.thisInstance();
    }

    @Override
    public TYPE asPackagePrivate() {
        this.primaryType().asPackagePrivate();
        return this.thisInstance();
    }

    @Override
    public TYPE asProtected() {
        this.primaryType().asProtected();
        return this.thisInstance();
    }

    @Override
    public TYPE asStatic() {
        this.primaryType().asStatic();
        return this.thisInstance();
    }

    @Override
    public TYPE asFinal() {
        this.primaryType().asFinal();
        return this.thisInstance();
    }

    @Override
    public TYPE withAnnotation(IAnnotationGenerator<?> builder) {
        this.primaryType().withAnnotation(builder);
        return this.thisInstance();
    }

    @Override
    public TYPE withoutAnnotation(String annotationFqn) {
        this.primaryType().withoutAnnotation(annotationFqn);
        return this.thisInstance();
    }

    @Override
    public TYPE withoutAnnotation(Predicate<IAnnotationGenerator<?>> removalFilter) {
        this.primaryType().withoutAnnotation(removalFilter);
        return this.thisInstance();
    }

    @Override
    public TYPE withoutAllAnnotations() {
        this.primaryType().withoutAllAnnotations();
        return this.thisInstance();
    }

    @Override
    public Stream<IAnnotationGenerator<?>> annotations() {
        return this.primaryType().annotations();
    }

    @Override
    public Optional<IAnnotationGenerator<?>> annotation(String annotationFqn) {
        return this.primaryType().annotation(annotationFqn);
    }

    @Override
    public TYPE withComment(ISourceGenerator<IJavaElementCommentBuilder<?>> commentBuilder) {
        this.primaryType().withComment(commentBuilder);
        return this.thisInstance();
    }

    @Override
    public Optional<ISourceGenerator<IJavaElementCommentBuilder<?>>> comment() {
        return this.primaryType().comment();
    }

    @Override
    public TYPE withElementName(String newName) {
        this.primaryType().withElementName(newName);
        this.compilationUnit().withElementName(newName);
        return this.thisInstance();
    }

    @Override
    public <A extends IApiSpecification> TYPE withElementNameFrom(Class<A> apiDefinition, Function<A, String> nameSupplier) {
        this.primaryType().withElementNameFrom(apiDefinition, nameSupplier);
        this.compilationUnit().withElementNameFrom(apiDefinition, nameSupplier);
        return this.thisInstance();
    }

    @Override
    public TYPE withElementNameFunc(Function<IJavaBuilderContext, String> nameSupplier) {
        this.primaryType().withElementNameFunc(nameSupplier);
        this.compilationUnit().withElementNameFunc(nameSupplier);
        return this.thisInstance();
    }

    @Override
    public Optional<String> elementName() {
        return this.primaryType().elementName();
    }

    @Override
    public Optional<String> elementName(IJavaBuilderContext context) {
        return this.primaryType().elementName(context);
    }

    @Override
    public Optional<JavaBuilderContextFunction<String>> elementNameFunc() {
        return this.primaryType().elementNameFunc();
    }

    @Override
    public Stream<String> interfaces() {
        return this.primaryType().interfaces();
    }

    @Override
    public Stream<JavaBuilderContextFunction<String>> interfacesFunc() {
        return this.primaryType().interfacesFunc();
    }

    @Override
    public TYPE withInterface(String interfaceReference) {
        this.primaryType().withInterface(interfaceReference);
        return this.thisInstance();
    }

    @Override
    public <A extends IApiSpecification> TYPE withInterfaceFrom(Class<A> apiDefinition, Function<A, String> interfaceSupplier) {
        this.primaryType().withInterfaceFrom(apiDefinition, interfaceSupplier);
        return this.thisInstance();
    }

    @Override
    public TYPE withInterfaceFunc(Function<IJavaBuilderContext, String> interfaceSupplier) {
        this.primaryType().withInterfaceFunc(interfaceSupplier);
        return this.thisInstance();
    }

    @Override
    public TYPE withInterfaces(Stream<String> interfaceReferences) {
        this.primaryType().withInterfaces(interfaceReferences);
        return this.thisInstance();
    }

    @Override
    public TYPE withoutInterface(String toRemove) {
        this.primaryType().withoutInterface(toRemove);
        return this.thisInstance();
    }

    @Override
    public TYPE withoutInterface(Predicate<JavaBuilderContextFunction<String>> filter) {
        this.primaryType().withoutInterface(filter);
        return this.thisInstance();
    }

    @Override
    public Optional<String> superClass() {
        return this.primaryType().superClass();
    }

    @Override
    public Optional<String> superClass(IJavaBuilderContext context) {
        return this.primaryType().superClass(context);
    }

    @Override
    public Optional<JavaBuilderContextFunction<String>> superClassFunc() {
        return this.primaryType().superClassFunc();
    }

    @Override
    public <A extends IApiSpecification> TYPE withSuperClassFrom(Class<A> apiDefinition, Function<A, String> superClassSupplier) {
        this.primaryType().withSuperClassFrom(apiDefinition, superClassSupplier);
        return this.thisInstance();
    }

    @Override
    public TYPE withSuperClassFunc(Function<IJavaBuilderContext, String> superClassSupplier) {
        this.primaryType().withSuperClassFunc(superClassSupplier);
        return this.thisInstance();
    }

    @Override
    public TYPE withSuperClass(String superType) {
        this.primaryType().withSuperClass(superType);
        return this.thisInstance();
    }

    @Override
    public String fullyQualifiedName() {
        return this.primaryType().fullyQualifiedName();
    }

    @Override
    public String qualifier() {
        return this.primaryType().qualifier();
    }

    @Override
    public Stream<IFieldGenerator<?>> fields() {
        return this.primaryType().fields();
    }

    @Override
    public TYPE withField(IFieldGenerator<?> builder, Object ... sortObject) {
        this.primaryType().withField(builder, sortObject);
        return this.thisInstance();
    }

    @Override
    public TYPE withoutField(Predicate<IFieldGenerator<?>> removalFilter) {
        this.primaryType().withoutField(removalFilter);
        return this.thisInstance();
    }

    @Override
    public Stream<IMethodGenerator<?, ?>> methods() {
        return this.primaryType().methods();
    }

    @Override
    public TYPE withMethod(IMethodGenerator<?, ?> builder, Object ... sortObject) {
        this.primaryType().withMethod(builder, sortObject);
        return this.thisInstance();
    }

    @Override
    public TYPE withoutMethod(Predicate<IMethodGenerator<?, ?>> removalFilter) {
        this.primaryType().withoutMethod(removalFilter);
        return this.thisInstance();
    }

    @Override
    public TYPE withoutMethod(String identifier, IJavaBuilderContext context) {
        this.primaryType().withoutMethod(identifier, context);
        return this.thisInstance();
    }

    @Override
    public Optional<IMethodGenerator<?, ?>> method(String methodId, IJavaBuilderContext context, boolean includeTypeArguments) {
        return this.primaryType().method(methodId, context, includeTypeArguments);
    }

    @Override
    public Stream<ITypeGenerator<?>> types() {
        return this.primaryType().types();
    }

    @Override
    public Optional<ITypeGenerator<?>> type(String simpleName) {
        return this.primaryType().type(simpleName);
    }

    @Override
    public TYPE withType(ITypeGenerator<?> generator, Object ... sortObject) {
        this.primaryType().withType(generator, sortObject);
        return this.thisInstance();
    }

    @Override
    public TYPE withoutType(String simpleName) {
        this.primaryType().withoutType(simpleName);
        return this.thisInstance();
    }

    @Override
    public TYPE withoutType(Predicate<ITypeGenerator<?>> removalFilter) {
        this.primaryType().withoutType(removalFilter);
        return this.thisInstance();
    }

    @Override
    public Stream<ITypeParameterGenerator<?>> typeParameters() {
        return this.primaryType().typeParameters();
    }

    @Override
    public TYPE withTypeParameter(ITypeParameterGenerator<?> typeParameter) {
        this.primaryType().withTypeParameter(typeParameter);
        return this.thisInstance();
    }

    @Override
    public TYPE withoutTypeParameter(String elementName) {
        this.primaryType().withoutTypeParameter(elementName);
        return this.thisInstance();
    }

    @Override
    public TYPE asInterface() {
        this.primaryType().asInterface();
        return this.thisInstance();
    }

    @Override
    public TYPE asAnnotationType() {
        this.primaryType().asAnnotationType();
        return this.thisInstance();
    }

    @Override
    public TYPE asEnum() {
        this.primaryType().asEnum();
        return this.thisInstance();
    }

    @Override
    public Optional<IJavaElementGenerator<?>> declaringGenerator() {
        return this.primaryType().declaringGenerator();
    }

    @Override
    public Optional<String> getDeclaringFullyQualifiedName() {
        return this.primaryType().getDeclaringFullyQualifiedName();
    }

    @Override
    public TYPE setDeclaringFullyQualifiedName(String parentFullyQualifiedName) {
        this.primaryType().setDeclaringFullyQualifiedName(parentFullyQualifiedName);
        return this.thisInstance();
    }

    @Override
    public IType getHierarchyType(IJavaBuilderContext context) {
        return this.primaryType().getHierarchyType(context);
    }

    @Override
    public TYPE withoutAllMethodsImplemented() {
        this.primaryType().withoutAllMethodsImplemented();
        return this.thisInstance();
    }

    @Override
    public TYPE withAllMethodsImplemented() {
        this.primaryType().withAllMethodsImplemented();
        return this.thisInstance();
    }

    @Override
    public TYPE withAllMethodsImplemented(IWorkingCopyTransformer callbackForMethodsAdded) {
        this.primaryType().withAllMethodsImplemented(callbackForMethodsAdded);
        return this.thisInstance();
    }

    @Override
    public TYPE withAllMethodsImplemented(IWorkingCopyTransformer callbackForMethodsAdded, Function<IMethodGenerator<?, ?>, Object[]> methodSortOrderProvider) {
        this.primaryType().withAllMethodsImplemented(callbackForMethodsAdded, methodSortOrderProvider);
        return this.thisInstance();
    }

    @Override
    public boolean isWithAllMethodsImplemented() {
        return this.primaryType().isWithAllMethodsImplemented();
    }

    @Override
    public TYPE withImport(CharSequence name) {
        this.compilationUnit().withImport(name);
        return this.thisInstance();
    }

    @Override
    public TYPE withoutImport(CharSequence name) {
        this.compilationUnit().withoutImport(name);
        return this.thisInstance();
    }

    @Override
    public Stream<CharSequence> imports() {
        return this.compilationUnit().imports();
    }

    @Override
    public TYPE withStaticImport(CharSequence name) {
        this.compilationUnit().withStaticImport(name);
        return this.thisInstance();
    }

    @Override
    public TYPE withoutStaticImport(CharSequence name) {
        this.compilationUnit().withoutStaticImport(name);
        return this.thisInstance();
    }

    @Override
    public Stream<CharSequence> staticImports() {
        return this.compilationUnit().staticImports();
    }

    @Override
    public TYPE withoutAllImports() {
        this.compilationUnit().withoutAllImports();
        return this.thisInstance();
    }

    @Override
    public TYPE withFooter(ISourceGenerator<ICommentBuilder<?>> builder) {
        this.compilationUnit().withFooter(builder);
        return this.thisInstance();
    }

    @Override
    public Stream<ISourceGenerator<ICommentBuilder<?>>> footers() {
        return this.compilationUnit().footers();
    }

    private boolean isSetupDone() {
        return this.m_setupDone;
    }

    private void setSetupDone() {
        this.m_setupDone = true;
    }
}

