/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.generator.field;

import java.util.Optional;
import java.util.function.Function;
import org.eclipse.scout.sdk.core.apidef.ApiFunction;
import org.eclipse.scout.sdk.core.apidef.IApiSpecification;
import org.eclipse.scout.sdk.core.builder.ISourceBuilder;
import org.eclipse.scout.sdk.core.builder.java.IJavaBuilderContext;
import org.eclipse.scout.sdk.core.builder.java.IJavaSourceBuilder;
import org.eclipse.scout.sdk.core.builder.java.JavaBuilderContextFunction;
import org.eclipse.scout.sdk.core.builder.java.comment.IJavaElementCommentBuilder;
import org.eclipse.scout.sdk.core.builder.java.comment.JavaElementCommentBuilder;
import org.eclipse.scout.sdk.core.builder.java.expression.ExpressionBuilder;
import org.eclipse.scout.sdk.core.builder.java.expression.IExpressionBuilder;
import org.eclipse.scout.sdk.core.builder.java.member.IMemberBuilder;
import org.eclipse.scout.sdk.core.builder.java.member.MemberBuilder;
import org.eclipse.scout.sdk.core.generator.ISourceGenerator;
import org.eclipse.scout.sdk.core.generator.SimpleGenerators;
import org.eclipse.scout.sdk.core.generator.field.IFieldGenerator;
import org.eclipse.scout.sdk.core.generator.member.AbstractMemberGenerator;
import org.eclipse.scout.sdk.core.model.api.IField;
import org.eclipse.scout.sdk.core.model.api.ISourceRange;
import org.eclipse.scout.sdk.core.transformer.IWorkingCopyTransformer;
import org.eclipse.scout.sdk.core.util.Ensure;
import org.eclipse.scout.sdk.core.util.Strings;

public class FieldGenerator<TYPE extends IFieldGenerator<TYPE>>
extends AbstractMemberGenerator<TYPE>
implements IFieldGenerator<TYPE> {
    public static final String SERIAL_VERSION_UID = "serialVersionUID";
    private JavaBuilderContextFunction<String> m_dataType;
    private ISourceGenerator<IExpressionBuilder<?>> m_valueGenerator;

    protected FieldGenerator() {
    }

    protected FieldGenerator(IField field, IWorkingCopyTransformer transformer) {
        super(field, transformer);
        this.withDataType(field.dataType().reference()).withValue(field.sourceOfInitializer().map(ISourceRange::asCharSequence).map(ISourceGenerator::raw).orElseGet(() -> field.constantValue().map(mv -> SimpleGenerators.createMetaValueGenerator(mv, transformer)).orElse(null)));
    }

    public static IFieldGenerator<?> create() {
        return new FieldGenerator();
    }

    public static IFieldGenerator<?> create(IField field, IWorkingCopyTransformer transformer) {
        return new FieldGenerator(field, transformer);
    }

    public static IFieldGenerator<?> createSerialVersionUid() {
        return FieldGenerator.createSerialVersionUid(1L);
    }

    public static IFieldGenerator<?> createSerialVersionUid(long value) {
        return ((IFieldGenerator)((IFieldGenerator)((IFieldGenerator)((IFieldGenerator)FieldGenerator.create().withElementName(SERIAL_VERSION_UID)).withDataType("long").asPrivate()).asStatic()).asFinal()).withValue(ISourceGenerator.raw(value + "L"));
    }

    @Override
    protected void build(IJavaSourceBuilder<?> builder) {
        super.build(builder);
        this.buildFieldSource(MemberBuilder.create(builder));
    }

    protected void buildFieldSource(IMemberBuilder<?> builder) {
        Optional<String> elementName = this.elementName(builder.context()).filter(Strings::hasText);
        if (elementName.isPresent()) {
            ((IMemberBuilder)((IMemberBuilder)builder.appendFlags(this.flags()).refFunc((Function<IJavaBuilderContext, CharSequence>)this.dataTypeFunc().orElseThrow(() -> Ensure.newFail("Field data type missing for builder {}", this)))).space()).append(FieldGenerator.ensureValidJavaName(elementName.orElseThrow()));
            this.value().ifPresent(v -> {
                builder.equalSign();
                FieldGenerator.buildFieldValue(ExpressionBuilder.create(builder), v);
            });
            builder.semicolon();
        } else if (this.value().isPresent()) {
            FieldGenerator.buildFieldValue(ExpressionBuilder.create(builder), this.value().orElseThrow());
        }
    }

    protected static void buildFieldValue(IExpressionBuilder<?> builder, ISourceGenerator<IExpressionBuilder<?>> valueGenerator) {
        valueGenerator.generate(builder);
    }

    @Override
    public Optional<String> dataType() {
        return this.dataTypeFunc().flatMap(JavaBuilderContextFunction::apply);
    }

    @Override
    public Optional<String> dataType(IJavaBuilderContext context) {
        return this.dataTypeFunc().map(f -> (String)f.apply(context));
    }

    @Override
    public Optional<JavaBuilderContextFunction<String>> dataTypeFunc() {
        return Optional.ofNullable(this.m_dataType);
    }

    @Override
    public TYPE withDataType(String dataType) {
        this.m_dataType = JavaBuilderContextFunction.orNull(dataType);
        return (TYPE)((IFieldGenerator)this.thisInstance());
    }

    @Override
    public <A extends IApiSpecification> TYPE withDataTypeFrom(Class<A> apiDefinition, Function<A, String> dataTypeSupplier) {
        this.m_dataType = new ApiFunction<A, String>(apiDefinition, dataTypeSupplier);
        return (TYPE)((IFieldGenerator)this.thisInstance());
    }

    @Override
    public TYPE withDataTypeFunc(Function<IJavaBuilderContext, String> dataTypeSupplier) {
        this.m_dataType = JavaBuilderContextFunction.orNull(dataTypeSupplier);
        return (TYPE)((IFieldGenerator)this.thisInstance());
    }

    @Override
    public Optional<ISourceGenerator<IExpressionBuilder<?>>> value() {
        return Optional.ofNullable(this.m_valueGenerator);
    }

    @Override
    public TYPE asVolatile() {
        return (TYPE)((IFieldGenerator)this.withFlags(64));
    }

    @Override
    public TYPE asTransient() {
        return (TYPE)((IFieldGenerator)this.withFlags(128));
    }

    @Override
    protected IJavaElementCommentBuilder<?> createCommentBuilder(ISourceBuilder<?> builder) {
        return JavaElementCommentBuilder.createForField(builder, this);
    }

    @Override
    public TYPE withValue(ISourceGenerator<IExpressionBuilder<?>> valueGenerator) {
        this.m_valueGenerator = valueGenerator;
        return (TYPE)((IFieldGenerator)this.thisInstance());
    }
}

