/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.generator.compilationunit;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.scout.sdk.core.builder.IBuilderContext;
import org.eclipse.scout.sdk.core.builder.ISourceBuilder;
import org.eclipse.scout.sdk.core.builder.java.IJavaSourceBuilder;
import org.eclipse.scout.sdk.core.builder.java.comment.CommentBuilder;
import org.eclipse.scout.sdk.core.builder.java.comment.ICommentBuilder;
import org.eclipse.scout.sdk.core.builder.java.comment.IJavaElementCommentBuilder;
import org.eclipse.scout.sdk.core.builder.java.comment.JavaElementCommentBuilder;
import org.eclipse.scout.sdk.core.generator.AbstractJavaElementGenerator;
import org.eclipse.scout.sdk.core.generator.IJavaElementGenerator;
import org.eclipse.scout.sdk.core.generator.ISourceGenerator;
import org.eclipse.scout.sdk.core.generator.PackageGenerator;
import org.eclipse.scout.sdk.core.generator.compilationunit.ICompilationUnitGenerator;
import org.eclipse.scout.sdk.core.generator.member.AbstractMemberGenerator;
import org.eclipse.scout.sdk.core.generator.member.IMemberGenerator;
import org.eclipse.scout.sdk.core.generator.type.ITypeGenerator;
import org.eclipse.scout.sdk.core.generator.type.SortedMemberEntry;
import org.eclipse.scout.sdk.core.imports.CompilationUnitScopedImportCollector;
import org.eclipse.scout.sdk.core.imports.IImportCollector;
import org.eclipse.scout.sdk.core.imports.IImportValidator;
import org.eclipse.scout.sdk.core.model.api.Flags;
import org.eclipse.scout.sdk.core.model.api.ICompilationUnit;
import org.eclipse.scout.sdk.core.model.api.IImport;
import org.eclipse.scout.sdk.core.model.api.IJavaElement;
import org.eclipse.scout.sdk.core.model.api.ISourceRange;
import org.eclipse.scout.sdk.core.transformer.IWorkingCopyTransformer;
import org.eclipse.scout.sdk.core.util.Ensure;
import org.eclipse.scout.sdk.core.util.Strings;

public class CompilationUnitGenerator<TYPE extends ICompilationUnitGenerator<TYPE>>
extends AbstractJavaElementGenerator<TYPE>
implements ICompilationUnitGenerator<TYPE> {
    private PackageGenerator m_package;
    private final List<CharSequence> m_declaredImports;
    private final List<CharSequence> m_declaredStaticImports;
    private final Collection<SortedMemberEntry> m_types;
    private final List<ISourceGenerator<ICommentBuilder<?>>> m_footerSourceBuilders;

    protected CompilationUnitGenerator() {
        this.m_declaredImports = new ArrayList<CharSequence>();
        this.m_declaredStaticImports = new ArrayList<CharSequence>();
        this.m_types = new ArrayList<SortedMemberEntry>();
        this.m_footerSourceBuilders = new ArrayList();
    }

    protected CompilationUnitGenerator(ICompilationUnit cu, IWorkingCopyTransformer transformer) {
        super(cu);
        this.m_package = IWorkingCopyTransformer.transformPackage(cu.containingPackage(), transformer).orElse(null);
        this.m_declaredImports = cu.imports().filter(i -> !i.isStatic()).map(i -> IWorkingCopyTransformer.transformImport(i, transformer)).flatMap(Optional::stream).collect(Collectors.toList());
        this.m_declaredStaticImports = cu.imports().filter(IImport::isStatic).map(i -> IWorkingCopyTransformer.transformImport(i, transformer)).flatMap(Optional::stream).collect(Collectors.toList());
        this.m_types = cu.types().stream().filter(t -> !t.elementName().equals("package-info")).map(t -> IWorkingCopyTransformer.transformType(t, transformer).map(g -> new SortedMemberEntry((IMemberGenerator<?>)g, (IJavaElement)t))).flatMap(Optional::stream).peek(entry -> CompilationUnitGenerator.applyConnection((ITypeGenerator)entry.generator(), this)).collect(Collectors.toList());
        this.m_footerSourceBuilders = new ArrayList();
        cu.javaDoc().map(ISourceRange::asCharSequence).map(s -> b -> {
            b.append((CharSequence)s);
            if (!Strings.endsWith(s, b.context().lineDelimiter())) {
                b.nl();
            }
        }).ifPresent(this::withComment);
    }

    public static ICompilationUnitGenerator<?> create() {
        return new CompilationUnitGenerator();
    }

    public static ICompilationUnitGenerator<?> create(ICompilationUnit cu, IWorkingCopyTransformer transformer) {
        return new CompilationUnitGenerator(cu, transformer);
    }

    @Override
    protected void build(IJavaSourceBuilder<?> builder) {
        IImportValidator currentValidator = builder.context().validator();
        currentValidator.runWithImportCollector(() -> this.buildCompilationUnit(builder), inner -> new CompilationUnitScopedImportCollector((IImportCollector)inner, this.packageName().orElse(null), this));
    }

    protected void buildCompilationUnit(IJavaSourceBuilder<?> builder) {
        super.build(builder);
        StringBuilder typeSource = this.buildTypeSource(builder.context());
        String nl = builder.context().lineDelimiter();
        ((IJavaSourceBuilder)((IJavaSourceBuilder)((IJavaSourceBuilder)((IJavaSourceBuilder)builder.append(this.getPackage().filter(pck -> pck.elementName(builder.context()).isPresent()).map(pck -> b -> b.append((ISourceGenerator<ISourceBuilder<?>>)pck).nl().nl()))).append(builder.context().validator().importCollector().createImportDeclarations().map(ISourceGenerator::raw), null, nl, nl)).append(typeSource)).nl()).append(this.footers().map(b -> b.generalize(CommentBuilder::create)), nl, nl, null);
    }

    protected StringBuilder buildTypeSource(IBuilderContext context) {
        ISourceGenerator<ISourceBuilder> typeGenerator = builder -> builder.append(this.m_types.stream().sorted().map(SortedMemberEntry::generator), context.lineDelimiter(), context.lineDelimiter() + context.lineDelimiter(), null);
        return typeGenerator.toSource(Function.identity(), context);
    }

    @Override
    protected IJavaElementCommentBuilder<?> createCommentBuilder(ISourceBuilder<?> builder) {
        return JavaElementCommentBuilder.createForCompilationUnit(builder, this);
    }

    @Override
    public Optional<PackageGenerator> getPackage() {
        return Optional.ofNullable(this.m_package);
    }

    @Override
    public Optional<String> packageName() {
        return this.getPackage().flatMap(AbstractJavaElementGenerator::elementName);
    }

    @Override
    public TYPE withPackage(PackageGenerator generator) {
        this.m_package = generator;
        return (TYPE)((ICompilationUnitGenerator)this.thisInstance());
    }

    @Override
    public TYPE withPackageName(String name) {
        if (this.m_package == null) {
            this.m_package = PackageGenerator.create();
        }
        this.m_package.withElementName(name);
        return (TYPE)((ICompilationUnitGenerator)this.thisInstance());
    }

    @Override
    public TYPE withImport(CharSequence name) {
        this.m_declaredImports.add(Ensure.notBlank(name));
        return (TYPE)((ICompilationUnitGenerator)this.thisInstance());
    }

    @Override
    public TYPE withoutImport(CharSequence name) {
        this.m_declaredImports.remove(name);
        return (TYPE)((ICompilationUnitGenerator)this.thisInstance());
    }

    @Override
    public Stream<CharSequence> imports() {
        return this.m_declaredImports.stream();
    }

    @Override
    public TYPE withStaticImport(CharSequence name) {
        this.m_declaredStaticImports.add(Ensure.notBlank(name));
        return (TYPE)((ICompilationUnitGenerator)this.thisInstance());
    }

    @Override
    public TYPE withoutStaticImport(CharSequence name) {
        this.m_declaredStaticImports.remove(name);
        return (TYPE)((ICompilationUnitGenerator)this.thisInstance());
    }

    @Override
    public Stream<CharSequence> staticImports() {
        return this.m_declaredStaticImports.stream();
    }

    @Override
    public TYPE withoutAllImports() {
        this.m_declaredImports.clear();
        this.m_declaredStaticImports.clear();
        return (TYPE)((ICompilationUnitGenerator)this.thisInstance());
    }

    @Override
    public Optional<ITypeGenerator<?>> mainType() {
        return this.types().filter(t -> Flags.isPublic(t.flags())).findAny();
    }

    @Override
    public Optional<String> elementName() {
        return super.elementName().map(s -> Strings.removeSuffix(s, ".java"));
    }

    @Override
    public TYPE withElementName(String newName) {
        if (newName != null && !newName.endsWith(".java")) {
            return (TYPE)((ICompilationUnitGenerator)super.withElementName(newName + ".java"));
        }
        return (TYPE)((ICompilationUnitGenerator)super.withElementName(newName));
    }

    @Override
    public Optional<String> fileName() {
        return super.elementName();
    }

    @Override
    public Stream<ITypeGenerator<?>> types() {
        return this.m_types.stream().map(SortedMemberEntry::generator).map(g -> (ITypeGenerator)g);
    }

    @Override
    public TYPE withType(ITypeGenerator<?> generator, Object ... sortObjects) {
        this.m_types.add(new SortedMemberEntry(CompilationUnitGenerator.applyConnection(generator, this), sortObjects));
        return (TYPE)((ICompilationUnitGenerator)this.thisInstance());
    }

    @Override
    public TYPE withoutType(Predicate<ITypeGenerator<?>> removalFilter) {
        Iterator<SortedMemberEntry> it = this.m_types.iterator();
        while (it.hasNext()) {
            ITypeGenerator generator = (ITypeGenerator)it.next().generator();
            if (removalFilter != null && !removalFilter.test(generator)) continue;
            it.remove();
            CompilationUnitGenerator.applyConnection(generator, null);
            return (TYPE)((ICompilationUnitGenerator)this.thisInstance());
        }
        return (TYPE)((ICompilationUnitGenerator)this.thisInstance());
    }

    protected static ITypeGenerator<?> applyConnection(ITypeGenerator<?> child, IJavaElementGenerator<?> parent) {
        if (child instanceof AbstractMemberGenerator) {
            ((AbstractMemberGenerator)((Object)child)).withDeclaringGenerator(parent);
        }
        return child;
    }

    @Override
    public TYPE withFooter(ISourceGenerator<ICommentBuilder<?>> builder) {
        if (builder != null) {
            this.m_footerSourceBuilders.add(builder);
        }
        return (TYPE)((ICompilationUnitGenerator)this.thisInstance());
    }

    @Override
    public Stream<ISourceGenerator<ICommentBuilder<?>>> footers() {
        return this.m_footerSourceBuilders.stream();
    }
}

