/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.generator.annotation;

import java.util.AbstractMap;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.scout.sdk.core.apidef.ApiFunction;
import org.eclipse.scout.sdk.core.apidef.IApiSpecification;
import org.eclipse.scout.sdk.core.apidef.ITypeNameSupplier;
import org.eclipse.scout.sdk.core.builder.java.IJavaBuilderContext;
import org.eclipse.scout.sdk.core.builder.java.IJavaSourceBuilder;
import org.eclipse.scout.sdk.core.builder.java.JavaBuilderContextFunction;
import org.eclipse.scout.sdk.core.builder.java.expression.ExpressionBuilder;
import org.eclipse.scout.sdk.core.builder.java.expression.IExpressionBuilder;
import org.eclipse.scout.sdk.core.generator.AbstractJavaElementGenerator;
import org.eclipse.scout.sdk.core.generator.ISourceGenerator;
import org.eclipse.scout.sdk.core.generator.annotation.IAnnotationGenerator;
import org.eclipse.scout.sdk.core.model.api.IAnnotation;
import org.eclipse.scout.sdk.core.model.api.IAnnotationElement;
import org.eclipse.scout.sdk.core.transformer.IWorkingCopyTransformer;
import org.eclipse.scout.sdk.core.util.Ensure;
import org.eclipse.scout.sdk.core.util.Strings;

public class AnnotationGenerator<TYPE extends IAnnotationGenerator<TYPE>>
extends AbstractJavaElementGenerator<TYPE>
implements IAnnotationGenerator<TYPE> {
    private final Map<JavaBuilderContextFunction<String>, ISourceGenerator<IExpressionBuilder<?>>> m_elements;

    protected AnnotationGenerator() {
        this.m_elements = new LinkedHashMap();
    }

    protected AnnotationGenerator(IAnnotation annotation, IWorkingCopyTransformer transformer) {
        super(annotation);
        this.withElementName(annotation.type().name());
        this.m_elements = annotation.elements().values().stream().filter(ae -> !ae.isDefault()).map(ae -> AnnotationGenerator.transformAndAssociateWithName(ae, transformer)).flatMap(Optional::stream).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, Ensure::failOnDuplicates, LinkedHashMap::new));
    }

    protected static Optional<Map.Entry<JavaBuilderContextFunction<String>, ISourceGenerator<IExpressionBuilder<?>>>> transformAndAssociateWithName(IAnnotationElement ae, IWorkingCopyTransformer transformer) {
        return IWorkingCopyTransformer.transformAnnotationElement(ae, transformer).map(g -> new AbstractMap.SimpleImmutableEntry<JavaBuilderContextFunction<String>, ISourceGenerator>(JavaBuilderContextFunction.create(ae.elementName()), (ISourceGenerator)g));
    }

    public static IAnnotationGenerator<?> create() {
        return new AnnotationGenerator();
    }

    public static IAnnotationGenerator<?> create(IAnnotation annotation, IWorkingCopyTransformer transformer) {
        return new AnnotationGenerator(annotation, transformer);
    }

    public static IAnnotationGenerator<?> createOverride() {
        return (IAnnotationGenerator)new AnnotationGenerator().withElementName(Override.class.getName());
    }

    public static IAnnotationGenerator<?> createGenerated(CharSequence typeThatGeneratedTheCode) {
        return AnnotationGenerator.createGenerated(typeThatGeneratedTheCode, "This class is auto generated. No manual modifications recommended.");
    }

    public static IAnnotationGenerator<?> createGenerated(CharSequence typeThatGeneratedTheCode, CharSequence comments) {
        Object result = ((IAnnotationGenerator)new AnnotationGenerator().withElementName("javax.annotation.Generated")).withElement("value", (IExpressionBuilder<?> b) -> b.stringLiteral(Ensure.notBlank(typeThatGeneratedTheCode)));
        Strings.notBlank(comments).ifPresent(c -> result.withElement("comments", (IExpressionBuilder<?> b) -> b.stringLiteral((CharSequence)c)));
        return result;
    }

    public static IAnnotationGenerator<?> createDeprecated() {
        return (IAnnotationGenerator)new AnnotationGenerator().withElementName(Deprecated.class.getName());
    }

    public static IAnnotationGenerator<?> createSuppressWarnings(CharSequence ... values) {
        return ((IAnnotationGenerator)new AnnotationGenerator().withElementName(SuppressWarnings.class.getName())).withElement("value", (IExpressionBuilder<?> b) -> b.stringLiteralArray(values, false, true));
    }

    @Override
    public <A extends IApiSpecification> TYPE withAnnotationNameFrom(Class<A> apiDefinition, Function<A, ITypeNameSupplier> nameSupplier) {
        if (nameSupplier == null) {
            return (TYPE)((IAnnotationGenerator)this.withElementNameFunc(null));
        }
        return (TYPE)((IAnnotationGenerator)this.withElementNameFunc((IJavaBuilderContext c) -> {
            ITypeNameSupplier classNameSupplier = (ITypeNameSupplier)new ApiFunction(apiDefinition, nameSupplier).apply((IJavaBuilderContext)c);
            return classNameSupplier == null ? null : classNameSupplier.fqn();
        }));
    }

    @Override
    public TYPE withElement(String name, CharSequence valueSrc) {
        return this.withElement(name, ISourceGenerator.raw(valueSrc));
    }

    @Override
    public TYPE withElement(String name, ISourceGenerator<IExpressionBuilder<?>> value) {
        if (value != null && Strings.hasText(name)) {
            this.m_elements.put(JavaBuilderContextFunction.create(name), value);
        }
        return (TYPE)((IAnnotationGenerator)this.thisInstance());
    }

    @Override
    public <A extends IApiSpecification> TYPE withElementFrom(Class<A> apiDefinition, Function<A, String> elementNameSupplier, CharSequence valueSrc) {
        return this.withElementFrom(apiDefinition, elementNameSupplier, ISourceGenerator.raw(valueSrc));
    }

    @Override
    public <A extends IApiSpecification> TYPE withElementFrom(Class<A> apiDefinition, Function<A, String> elementNameSupplier, ISourceGenerator<IExpressionBuilder<?>> value) {
        if (value != null && elementNameSupplier != null) {
            this.m_elements.put(new ApiFunction<A, String>(apiDefinition, elementNameSupplier), value);
        }
        return (TYPE)((IAnnotationGenerator)this.thisInstance());
    }

    @Override
    public TYPE withElementFunc(Function<IJavaBuilderContext, String> elementNameSupplier, CharSequence valueSrc) {
        return this.withElementFunc(elementNameSupplier, ISourceGenerator.raw(valueSrc));
    }

    @Override
    public TYPE withElementFunc(Function<IJavaBuilderContext, String> elementNameSupplier, ISourceGenerator<IExpressionBuilder<?>> value) {
        if (value != null && elementNameSupplier != null) {
            this.m_elements.put(JavaBuilderContextFunction.create(elementNameSupplier), value);
        }
        return (TYPE)((IAnnotationGenerator)this.thisInstance());
    }

    @Override
    public Optional<ISourceGenerator<IExpressionBuilder<?>>> element(String name) {
        return this.m_elements.entrySet().stream().filter(e -> ((JavaBuilderContextFunction)e.getKey()).apply().filter(Predicate.isEqual(name)).isPresent()).reduce((a, b) -> b).map(Map.Entry::getValue);
    }

    @Override
    public Optional<ISourceGenerator<IExpressionBuilder<?>>> element(Predicate<JavaBuilderContextFunction<String>> selector) {
        Ensure.notNull(selector, "Element selector must not be null.", new Object[0]);
        return this.m_elements.entrySet().stream().filter(entry -> selector.test((JavaBuilderContextFunction)entry.getKey())).reduce((a, b) -> b).map(Map.Entry::getValue);
    }

    @Override
    public Map<String, ISourceGenerator<IExpressionBuilder<?>>> elements() {
        return this.elementsFunc().entrySet().stream().map(e -> ((JavaBuilderContextFunction)e.getKey()).apply().map(elementName -> new AbstractMap.SimpleImmutableEntry<String, ISourceGenerator>((String)elementName, (ISourceGenerator)e.getValue()))).flatMap(Optional::stream).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (a, b) -> b, LinkedHashMap::new));
    }

    @Override
    public Map<JavaBuilderContextFunction<String>, ISourceGenerator<IExpressionBuilder<?>>> elementsFunc() {
        return Collections.unmodifiableMap(this.m_elements);
    }

    @Override
    public TYPE withoutElement(String elementName) {
        return this.withoutElement((JavaBuilderContextFunction<String> f) -> f.apply().filter(Predicate.isEqual(elementName)).isPresent());
    }

    @Override
    public TYPE withoutElement(Predicate<JavaBuilderContextFunction<String>> toRemove) {
        if (toRemove == null) {
            this.m_elements.clear();
        } else {
            this.m_elements.keySet().removeIf(toRemove);
        }
        return (TYPE)((IAnnotationGenerator)this.thisInstance());
    }

    @Override
    protected void build(IJavaSourceBuilder<?> builder) {
        super.build(builder);
        String annotationName = this.elementName(builder.context()).orElseThrow(() -> Ensure.newFail("Annotation name missing for generator {}", this));
        builder.at().ref(annotationName);
        if (this.m_elements.isEmpty()) {
            return;
        }
        builder.parenthesisOpen();
        this.buildElements(ExpressionBuilder.create(builder));
        builder.parenthesisClose();
    }

    protected void buildElements(IExpressionBuilder<?> builder) {
        IJavaBuilderContext context = builder.context();
        LinkedHashMap elementMap = this.m_elements.entrySet().stream().map(entry -> new AbstractMap.SimpleImmutableEntry<String, ISourceGenerator>((String)((JavaBuilderContextFunction)entry.getKey()).apply(context), (ISourceGenerator)entry.getValue())).filter(entry -> !Strings.isEmpty((CharSequence)entry.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (a, b) -> b, LinkedHashMap::new));
        boolean isSingleValueAnnotation = AnnotationGenerator.buildSingleValueAnnotation(elementMap, builder);
        if (!isSingleValueAnnotation) {
            AnnotationGenerator.buildNamedValueAnnotation(elementMap, builder);
        }
    }

    protected static void buildNamedValueAnnotation(Map<String, ISourceGenerator<IExpressionBuilder<?>>> elementMap, IExpressionBuilder<?> builder) {
        StringBuilder elementDelimiter = new StringBuilder(3);
        elementDelimiter.append(',');
        if (elementMap.size() > 4) {
            elementDelimiter.append(builder.context().lineDelimiter());
        } else {
            elementDelimiter.append(' ');
        }
        Stream<ISourceGenerator> elementGenerators = elementMap.entrySet().stream().map(e -> AnnotationGenerator.toElementGenerator(builder, (String)e.getKey(), (ISourceGenerator)e.getValue())).map(g -> g.generalize(builder));
        builder.append(elementGenerators, null, elementDelimiter, null);
    }

    protected static ISourceGenerator<IJavaSourceBuilder<?>> toElementGenerator(IExpressionBuilder<?> builder, String elementName, ISourceGenerator<IExpressionBuilder<?>> valueGenerator) {
        return b -> ((IJavaSourceBuilder)b.append(elementName)).equalSign().append(valueGenerator.generalize(builder));
    }

    protected static boolean buildSingleValueAnnotation(Map<String, ISourceGenerator<IExpressionBuilder<?>>> elementMap, IExpressionBuilder<?> builder) {
        if (elementMap.size() != 1) {
            return false;
        }
        Map.Entry<String, ISourceGenerator<IExpressionBuilder<?>>> element = elementMap.entrySet().iterator().next();
        String elementName = element.getKey();
        ISourceGenerator<IExpressionBuilder<?>> valueGenerator = element.getValue();
        if (!"value".equals(elementName)) {
            return false;
        }
        valueGenerator.generate(builder);
        return true;
    }
}

