/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.builder.java.body;

import java.util.Optional;
import java.util.stream.Stream;
import org.eclipse.scout.sdk.core.builder.ISourceBuilder;
import org.eclipse.scout.sdk.core.builder.java.body.IMethodBodyBuilder;
import org.eclipse.scout.sdk.core.builder.java.comment.CommentBuilder;
import org.eclipse.scout.sdk.core.builder.java.comment.ICommentBuilder;
import org.eclipse.scout.sdk.core.builder.java.expression.ExpressionBuilder;
import org.eclipse.scout.sdk.core.builder.java.expression.IExpressionBuilder;
import org.eclipse.scout.sdk.core.generator.AbstractJavaElementGenerator;
import org.eclipse.scout.sdk.core.generator.ISourceGenerator;
import org.eclipse.scout.sdk.core.generator.method.IMethodGenerator;
import org.eclipse.scout.sdk.core.util.Ensure;

public class MethodBodyBuilder<TYPE extends IMethodBodyBuilder<TYPE>>
extends ExpressionBuilder<TYPE>
implements IMethodBodyBuilder<TYPE> {
    private final IMethodGenerator<?, ?> m_surroundingMethod;
    private final ICommentBuilder<?> m_commentBuilder;

    protected MethodBodyBuilder(ISourceBuilder<?> inner, IMethodGenerator<?, ?> surroundingMethod) {
        super(inner);
        this.m_surroundingMethod = Ensure.notNull(surroundingMethod);
        this.m_commentBuilder = CommentBuilder.create(inner);
    }

    public static IMethodBodyBuilder<?> create(ISourceBuilder<?> inner, IMethodGenerator<?, ?> surroundingMethod) {
        return new MethodBodyBuilder(inner, surroundingMethod);
    }

    @Override
    public TYPE appendAutoGenerated() {
        this.appendTodoAutoGeneratedMethodStub();
        this.surroundingMethodReturnTypeIfNotVoid().ifPresent(ret -> ((IMethodBodyBuilder)this.returnClause().appendDefaultValueOf((CharSequence)ret)).semicolon());
        return (TYPE)((IMethodBodyBuilder)this.thisInstance());
    }

    @Override
    public TYPE superClause() {
        return (TYPE)((IMethodBodyBuilder)this.append("super"));
    }

    @Override
    public TYPE returnClause() {
        return (TYPE)((IMethodBodyBuilder)this.append("return "));
    }

    @Override
    public TYPE appendThis() {
        return (TYPE)((IMethodBodyBuilder)this.append("this"));
    }

    @Override
    public TYPE appendSuperCall() {
        return this.appendCallToSame("super");
    }

    @Override
    public TYPE appendCallToSame(CharSequence prefixSource) {
        if (this.needsReturnClause()) {
            this.returnClause();
        }
        if (prefixSource != null) {
            this.append(prefixSource);
        }
        if (!this.surroundingMethod().isConstructor()) {
            ((IMethodBodyBuilder)this.dot()).append(this.surroundingMethod().elementName(this.context()).orElseThrow(() -> Ensure.newFail("Cannot create a super call because method has no name.", new Object[0])));
        }
        Stream<ISourceGenerator> parameterNames = this.surroundingMethod().parameters().map(p -> p.elementName(this.context()).orElseThrow(() -> Ensure.newFail("Parameter has no name", new Object[0]))).map(ISourceGenerator::raw);
        return (TYPE)((IMethodBodyBuilder)((IMethodBodyBuilder)((IMethodBodyBuilder)((IMethodBodyBuilder)this.parenthesisOpen()).append(parameterNames, null, ", ", null)).parenthesisClose()).semicolon());
    }

    @Override
    public TYPE appendParameterName(int index) {
        String declaredParameterName = this.surroundingMethod().parameters().skip(index).findAny().orElseThrow(() -> Ensure.newFail("Cannot find parameter with index {} in method {}.", index, this.surroundingMethod().elementName(this.context()).orElse(null))).elementName(this.context()).orElseThrow(() -> Ensure.newFail("Parameter with index {} in method {} has no name.", index, this.surroundingMethod().elementName(this.context()).orElse(null)));
        return (TYPE)((IMethodBodyBuilder)this.append(AbstractJavaElementGenerator.ensureValidJavaName(declaredParameterName)));
    }

    @Override
    public TYPE returnClassLiteral(String type) {
        return (TYPE)((IMethodBodyBuilder)((IMethodBodyBuilder)this.returnClause().classLiteral(type)).semicolon());
    }

    @Override
    public TYPE appendBlockCommentStart() {
        this.m_commentBuilder.appendBlockCommentStart();
        return (TYPE)((IMethodBodyBuilder)this.thisInstance());
    }

    @Override
    public TYPE appendJavaDocStart() {
        this.m_commentBuilder.appendJavaDocStart();
        return (TYPE)((IMethodBodyBuilder)this.thisInstance());
    }

    @Override
    public TYPE appendJavaDocLine(CharSequence comment) {
        this.m_commentBuilder.appendJavaDocLine(comment);
        return (TYPE)((IMethodBodyBuilder)this.thisInstance());
    }

    @Override
    public TYPE appendBlockCommentEnd() {
        this.m_commentBuilder.appendBlockCommentEnd();
        return (TYPE)((IMethodBodyBuilder)this.thisInstance());
    }

    @Override
    public TYPE appendBlockComment(String comment) {
        this.m_commentBuilder.appendBlockComment(comment);
        return (TYPE)((IMethodBodyBuilder)this.thisInstance());
    }

    @Override
    public TYPE appendJavaDocComment(String comment) {
        this.m_commentBuilder.appendJavaDocComment(comment);
        return (TYPE)((IMethodBodyBuilder)this.thisInstance());
    }

    @Override
    public TYPE appendTodo(CharSequence toDoMessage) {
        this.m_commentBuilder.appendTodo(toDoMessage);
        return (TYPE)((IMethodBodyBuilder)this.thisInstance());
    }

    @Override
    public TYPE appendTodoAutoGeneratedMethodStub() {
        this.m_commentBuilder.appendTodoAutoGeneratedMethodStub();
        return (TYPE)((IMethodBodyBuilder)this.thisInstance());
    }

    @Override
    public TYPE appendSingleLineComment(CharSequence msg) {
        this.m_commentBuilder.appendSingleLineComment(msg);
        return (TYPE)((IMethodBodyBuilder)this.thisInstance());
    }

    @Override
    public boolean needsReturnClause() {
        return this.surroundingMethodReturnTypeIfNotVoid().isPresent();
    }

    protected Optional<String> surroundingMethodReturnTypeIfNotVoid() {
        return this.surroundingMethodReturnType().filter(type -> !"void".equals(type));
    }

    @Override
    public Optional<String> surroundingMethodReturnType() {
        return this.surroundingMethod().returnType(this.context());
    }

    @Override
    public IMethodGenerator<?, ?> surroundingMethod() {
        return this.m_surroundingMethod;
    }

    @Override
    public TYPE appendNewInstance(CharSequence fqn, CharSequence variableName, ISourceGenerator<IExpressionBuilder<?>> constructorArg) {
        IMethodBodyBuilder newInstance = (IMethodBodyBuilder)((IMethodBodyBuilder)((IMethodBodyBuilder)((IMethodBodyBuilder)((IMethodBodyBuilder)this.ref(fqn)).space()).append(variableName)).equalSign()).appendNew(fqn);
        if (constructorArg != null) {
            newInstance.append(constructorArg.generalize(ExpressionBuilder::create));
        }
        ((IMethodBodyBuilder)newInstance.parenthesisClose()).semicolon();
        return (TYPE)newInstance;
    }
}

