/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.builder;

import java.io.Flushable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.eclipse.scout.sdk.core.builder.AbstractSourceBuilder;
import org.eclipse.scout.sdk.core.builder.BuilderContext;
import org.eclipse.scout.sdk.core.builder.IBuilderContext;
import org.eclipse.scout.sdk.core.util.Ensure;
import org.eclipse.scout.sdk.core.util.SdkException;

public class StreamSourceBuilder
extends AbstractSourceBuilder<StreamSourceBuilder>
implements AutoCloseable,
Flushable {
    private final Writer m_writer;

    public StreamSourceBuilder(OutputStream out) {
        this(out, StandardCharsets.UTF_8);
    }

    public StreamSourceBuilder(OutputStream out, Charset charset) {
        this(out, charset, new BuilderContext());
    }

    public StreamSourceBuilder(OutputStream out, Charset charset, IBuilderContext context) {
        super(context);
        this.m_writer = new OutputStreamWriter(Ensure.notNull(out), Ensure.notNull(charset));
    }

    public Writer source() {
        return this.m_writer;
    }

    @Override
    public StreamSourceBuilder append(char c) {
        try {
            this.source().append(c);
            return (StreamSourceBuilder)this.thisInstance();
        }
        catch (IOException e) {
            throw new SdkException(e);
        }
    }

    @Override
    public StreamSourceBuilder append(CharSequence seq) {
        try {
            this.source().append(seq);
            return (StreamSourceBuilder)this.thisInstance();
        }
        catch (IOException e) {
            throw new SdkException(e);
        }
    }

    @Override
    public void flush() {
        try {
            this.m_writer.flush();
        }
        catch (IOException e) {
            throw new SdkException(e);
        }
    }

    @Override
    public void close() {
        try {
            this.m_writer.close();
        }
        catch (IOException e) {
            throw new SdkException(e);
        }
    }
}

