/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.apidef;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Predicate;
import org.eclipse.scout.sdk.core.apidef.ApiVersion;
import org.eclipse.scout.sdk.core.apidef.IApiSpecification;
import org.eclipse.scout.sdk.core.log.MessageFormatter;
import org.eclipse.scout.sdk.core.util.CoreUtils;
import org.eclipse.scout.sdk.core.util.Ensure;
import org.eclipse.scout.sdk.core.util.FinalValue;
import org.eclipse.scout.sdk.core.util.JavaTypes;

public class ApiSpecification
implements InvocationHandler,
IApiSpecification {
    private final FinalValue<ApiVersion> m_level;
    private final Map<Class<? extends IApiSpecification>, Optional<?>> m_apiCache;
    private final Map<String, Map.Entry<Method, ApiSpecification>> m_methods;
    private final Class<? extends IApiSpecification> m_interface;
    private final FinalValue<IApiSpecification> m_implementation;
    private final ApiSpecification m_nestedApi;

    protected ApiSpecification(ApiSpecification nestedApi, Class<? extends IApiSpecification> ifc) {
        this.m_interface = Ensure.notNull(ifc);
        this.m_nestedApi = nestedApi;
        this.m_implementation = new FinalValue();
        this.m_level = new FinalValue();
        this.m_apiCache = new ConcurrentHashMap();
        this.m_methods = new HashMap<String, Map.Entry<Method, ApiSpecification>>();
    }

    static IApiSpecification create(Collection<Class<? extends IApiSpecification>> apiClasses, ApiVersion version) {
        AtomicBoolean firstNewerSpecConsumed = new AtomicBoolean();
        ApiSpecification root = apiClasses.stream().map(ApiSpecification::associateWithLevel).sorted(Map.Entry.comparingByKey()).filter(e -> ApiSpecification.accept((Comparable)e.getKey(), version, firstNewerSpecConsumed)).map(Map.Entry::getValue).reduce(null, ApiSpecification::wrapWith, Ensure::failOnDuplicates);
        if (root == null) {
            return null;
        }
        ApiSpecification.mergeMethodsIntoCache(root);
        return root.apiImplementation();
    }

    static boolean accept(Comparable<ApiVersion> spec, ApiVersion request, AtomicBoolean firstNewerSpecConsumed) {
        if (request == null || request == ApiVersion.LATEST) {
            return true;
        }
        if (spec.compareTo(request) < 0) {
            return true;
        }
        if (firstNewerSpecConsumed.get()) {
            return false;
        }
        firstNewerSpecConsumed.set(true);
        return true;
    }

    static Map.Entry<ApiVersion, Class<? extends IApiSpecification>> associateWithLevel(Class<? extends IApiSpecification> definition) {
        return new AbstractMap.SimpleEntry<ApiVersion, Class<? extends IApiSpecification>>(ApiVersion.requireMaxApiLevelOf(definition), definition);
    }

    static ApiSpecification wrapWith(ApiSpecification nested, Class<? extends IApiSpecification> wrapperInterface) {
        return new ApiSpecification(nested, wrapperInterface);
    }

    public IApiSpecification nestedApiImplementation() {
        return this.m_nestedApi;
    }

    public Class<? extends IApiSpecification> apiInterface() {
        return this.m_interface;
    }

    public IApiSpecification apiImplementation() {
        return this.m_implementation.computeIfAbsentAndGet(() -> this.apiInterface().cast(Proxy.newProxyInstance(this.apiInterface().getClassLoader(), new Class[]{this.apiInterface()}, (InvocationHandler)this)));
    }

    @Override
    public ApiVersion maxLevel() {
        return this.m_level.computeIfAbsentAndGet(() -> ApiVersion.requireMaxApiLevelOf(this.apiInterface()));
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) {
        String methodName;
        if (method.getDeclaringClass() == Object.class) {
            switch (methodName = method.getName()) {
                case "hashCode": {
                    return System.identityHashCode(proxy);
                }
                case "equals": {
                    return proxy == args[0];
                }
                case "toString": {
                    return MessageFormatter.arrayFormat("ApiSpecification [maxLevel={}, class={}]", this.maxLevel().asString(), this.apiInterface().getName()).message();
                }
            }
        }
        if (method.getDeclaringClass() == IApiSpecification.class) {
            switch (methodName = method.getName()) {
                case "maxLevel": {
                    return this.maxLevel();
                }
                case "api": {
                    return this.api((Class)args[0]);
                }
                case "requireApi": {
                    return this.requireApi((Class)args[0]);
                }
            }
        }
        return this.invokeIfcMethod(method, args);
    }

    protected Object invokeIfcMethod(Method methodTemplate, Object[] args) {
        String methodIdToFind = JavaTypes.createMethodIdentifier(methodTemplate);
        Map.Entry<Method, ApiSpecification> methodSpec = this.m_methods.get(methodIdToFind);
        if (methodSpec == null) {
            throw Ensure.newFail("Pure virtual function call: {}", methodTemplate);
        }
        ApiSpecification spec = methodSpec.getValue();
        return CoreUtils.invokeDefaultMethod(spec.apiImplementation(), methodSpec.getKey(), args);
    }

    protected static void mergeMethodsIntoCache(ApiSpecification spec) {
        Optional.ofNullable(spec.m_nestedApi).ifPresent(ApiSpecification::mergeMethodsIntoCache);
        Arrays.stream(spec.apiInterface().getMethods()).filter(Method::isDefault).filter(m -> !m.isBridge() && !m.isSynthetic()).forEach(m -> spec.m_methods.putIfAbsent(JavaTypes.createMethodIdentifier(m), new AbstractMap.SimpleImmutableEntry<Method, ApiSpecification>((Method)m, spec)));
        Optional.ofNullable(spec.m_nestedApi).ifPresent(nestedApi -> nestedApi.m_methods.forEach(spec.m_methods::putIfAbsent));
    }

    @Override
    public <A extends IApiSpecification> A requireApi(Class<A> apiDefinition) {
        return (A)((IApiSpecification)this.api(apiDefinition).orElseThrow(() -> Ensure.newFail("API {} is not supported.", apiDefinition.getSimpleName())));
    }

    @Override
    public <A extends IApiSpecification> Optional<A> api(Class<A> apiDefinition) {
        Class key = apiDefinition == null ? IApiSpecification.class : apiDefinition;
        return this.m_apiCache.computeIfAbsent(key, this::computeApi);
    }

    protected <A extends IApiSpecification> Optional<A> computeApi(Class<A> apiDefinition) {
        if (apiDefinition == IApiSpecification.class) {
            return Optional.empty();
        }
        FinalValue result = new FinalValue();
        this.doInChain(invocationHandler -> {
            IApiSpecification candidate = invocationHandler.apiImplementation();
            if (apiDefinition.isInstance(candidate)) {
                result.set(candidate);
                return false;
            }
            return true;
        });
        return result.opt();
    }

    protected void doInChain(Predicate<ApiSpecification> chainFunction) {
        ApiSpecification invocationHandler = this;
        do {
            if (chainFunction.test(invocationHandler)) continue;
            return;
        } while ((invocationHandler = invocationHandler.m_nestedApi) != null);
    }
}

