/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.apidef;

import java.util.Optional;
import java.util.function.Function;
import org.eclipse.scout.sdk.core.apidef.IApiSpecification;
import org.eclipse.scout.sdk.core.builder.java.IJavaBuilderContext;
import org.eclipse.scout.sdk.core.builder.java.JavaBuilderContextFunction;
import org.eclipse.scout.sdk.core.model.api.IJavaEnvironment;
import org.eclipse.scout.sdk.core.util.Ensure;

public class ApiFunction<API extends IApiSpecification, RET>
extends JavaBuilderContextFunction<RET> {
    private final Class<API> m_apiClass;
    private final Function<API, RET> m_apiFunction;

    public ApiFunction(RET constantValue) {
        this(null, api -> constantValue);
    }

    public ApiFunction(Class<API> apiClass, Function<API, RET> function) {
        super((IJavaBuilderContext c) -> ApiFunction.applyApi(apiClass, function, c), apiClass != null);
        this.m_apiClass = apiClass;
        this.m_apiFunction = Ensure.notNull(function);
    }

    protected static <API extends IApiSpecification, RET> RET applyApi(Class<API> apiDefinition, Function<API, RET> task, IJavaBuilderContext context) {
        if (apiDefinition == null) {
            return task.apply(null);
        }
        return ApiFunction.applyApi(apiDefinition, task, context.environment().orElse(null));
    }

    protected static <API extends IApiSpecification, RET> RET applyApi(Class<API> apiDefinition, Function<API, RET> task, IJavaEnvironment context) {
        if (apiDefinition == null) {
            return task.apply(null);
        }
        return Optional.ofNullable(context).flatMap(c -> c.api(apiDefinition)).map(task).orElse(null);
    }

    @Override
    public Optional<RET> apply(IJavaEnvironment context) {
        return Optional.ofNullable(ApiFunction.applyApi(this.m_apiClass, this.m_apiFunction, context));
    }

    public Optional<Class<API>> apiClass() {
        return Optional.ofNullable(this.m_apiClass);
    }

    public Function<API, RET> apiFunction() {
        return this.m_apiFunction;
    }
}

