/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.progress;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.TaskItem;
import org.eclipse.ui.internal.progress.GroupInfo;
import org.eclipse.ui.internal.progress.IJobProgressManagerListener;
import org.eclipse.ui.internal.progress.JobInfo;
import org.eclipse.ui.internal.progress.ProgressManager;
import org.eclipse.ui.internal.progress.ProgressMessages;
import org.eclipse.ui.progress.IProgressConstants;
import org.eclipse.ui.progress.IProgressConstants2;
import org.eclipse.ui.progress.WorkbenchJob;

public class TaskBarProgressManager {
    private IJobProgressManagerListener listener;
    private WorkbenchJob updateJob;
    private List<Job> jobs = Collections.synchronizedList(new ArrayList());
    private Map<Job, JobInfo> jobInfoMap = Collections.synchronizedMap(new HashMap());
    private final TaskItem taskItem;
    private ImageDescriptor overlayDescriptor;
    private Image overlayImage;

    public TaskBarProgressManager(TaskItem taskItem) {
        Assert.isNotNull((Object)taskItem);
        this.taskItem = taskItem;
        this.updateJob = this.getUpdateJob();
        this.updateJob.setSystem(true);
        this.listener = this.getProgressListener();
        ProgressManager.getInstance().addListener(this.listener);
        taskItem.addDisposeListener(e -> this.dispose());
    }

    public void dispose() {
        ProgressManager.getInstance().removeListener(this.listener);
        this.disposeOverlay();
    }

    private WorkbenchJob getUpdateJob() {
        return new WorkbenchJob(ProgressMessages.ProgressToolItem_Update){

            @Override
            public IStatus runInUIThread(IProgressMonitor monitor) {
                this.setProgressState(-1);
                TaskBarProgressManager.this.updateImage(null);
                return Status.OK_STATUS;
            }

            private void setProgressState(int state) {
                if (!TaskBarProgressManager.this.taskItem.isDisposed() && TaskBarProgressManager.this.taskItem.getProgressState() != state) {
                    TaskBarProgressManager.this.taskItem.setProgressState(-1);
                    TaskBarProgressManager.this.taskItem.setProgressState(state);
                }
            }
        };
    }

    private void updateImage(Job job) {
        if (this.taskItem == null || this.taskItem.isDisposed()) {
            return;
        }
        if (job == null) {
            this.disposeOverlay();
            this.taskItem.setOverlayImage(null);
            return;
        }
        ImageDescriptor descriptor = (ImageDescriptor)job.getProperty(IProgressConstants.ICON_PROPERTY);
        if (descriptor != null) {
            if (!descriptor.equals(this.overlayDescriptor)) {
                this.disposeOverlay();
                this.setOverlay(descriptor);
            }
        } else if (ProgressManager.getInstance().getIconFor(job) != null) {
            this.disposeOverlay();
            Image newImage = ProgressManager.getInstance().getIconFor(job);
            this.taskItem.setOverlayImage(newImage);
        } else {
            this.disposeOverlay();
            this.taskItem.setOverlayImage(null);
        }
    }

    private void setOverlay(ImageDescriptor descriptor) {
        this.overlayDescriptor = descriptor;
        this.overlayImage = descriptor.createImage();
        this.taskItem.setOverlayImage(this.overlayImage);
    }

    private void disposeOverlay() {
        this.overlayDescriptor = null;
        if (this.overlayImage != null) {
            this.overlayImage.dispose();
            this.overlayImage = null;
        }
    }

    private IJobProgressManagerListener getProgressListener() {
        return new IJobProgressManagerListener(){

            @Override
            public void addJob(JobInfo info) {
                if (this.isNotTracked(info)) {
                    return;
                }
                if (!TaskBarProgressManager.this.jobs.contains(info.getJob())) {
                    TaskBarProgressManager.this.jobs.add(info.getJob());
                }
                TaskBarProgressManager.this.jobInfoMap.put(info.getJob(), info);
            }

            @Override
            public void refreshJobInfo(JobInfo info) {
                int state = info.getJob().getState();
                if (state == 4) {
                    this.addJob(info);
                } else {
                    this.removeJob(info);
                }
            }

            @Override
            public void refreshAll() {
                ProgressManager manager = ProgressManager.getInstance();
                TaskBarProgressManager.this.jobs.clear();
                TaskBarProgressManager.this.jobInfoMap.clear();
                JobInfo[] jobInfoArray = manager.getJobInfos(this.showsDebug());
                int n = jobInfoArray.length;
                int n2 = 0;
                while (n2 < n) {
                    JobInfo currentInfo = jobInfoArray[n2];
                    this.addJob(currentInfo);
                    ++n2;
                }
            }

            @Override
            public void removeJob(JobInfo info) {
                TaskBarProgressManager.this.jobs.remove(info.getJob());
                TaskBarProgressManager.this.jobInfoMap.remove(info.getJob());
            }

            @Override
            public boolean showsDebug() {
                return false;
            }

            private boolean isNotTracked(JobInfo info) {
                Job job = info.getJob();
                return job.getState() != 4 || !this.shouldShowSystemProgress(info);
            }

            private boolean shouldShowSystemProgress(JobInfo info) {
                Boolean showInTaskBarIcon = Boolean.FALSE;
                Object property = info.getJob().getProperty(IProgressConstants2.SHOW_IN_TASKBAR_ICON_PROPERTY);
                if (property instanceof Boolean) {
                    showInTaskBarIcon = (Boolean)property;
                }
                return showInTaskBarIcon;
            }

            @Override
            public void addGroup(GroupInfo info) {
            }

            @Override
            public void removeGroup(GroupInfo group) {
            }

            @Override
            public void refreshGroup(GroupInfo info) {
            }
        };
    }
}

