/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.utils.tests;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.compare.ide.utils.ResourceUtil;
import org.eclipse.emf.compare.ide.utils.tests.AbstractStorageTest;
import org.eclipse.emf.compare.ide.utils.tests.helper.BufferedInputStreamProvider;
import org.eclipse.emf.compare.ide.utils.tests.helper.ByteArrayInputStreamProvider;
import org.eclipse.emf.compare.ide.utils.tests.helper.FileInputStreamProvider;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.osgi.framework.Bundle;

public class ResourceUtil_BinaryIdentical3Test
extends AbstractStorageTest {
    private static final String PATH1 = "src/org/eclipse/emf/compare/ide/utils/tests/data/binaryequalitytestinputdata1";
    private static final String PATH2 = "src/org/eclipse/emf/compare/ide/utils/tests/data/binaryequalitytestinputdata2";
    File file1;
    File file2;
    IStorage storage1_stream;
    IStorage storage1_stream2;
    IStorage storage2_stream;

    @Before
    public void setUp() throws IOException {
        Bundle bundle = Platform.getBundle((String)"org.eclipse.emf.compare.ide.tests");
        URL file1Entry = bundle.getEntry(PATH1);
        URL file1URL = FileLocator.resolve((URL)file1Entry);
        String file1Path = file1URL.getPath();
        URL file2Entry = bundle.getEntry(PATH2);
        URL file2URL = FileLocator.resolve((URL)file2Entry);
        String file2Path = file2URL.getPath();
        this.file1 = new File(file1Path);
        this.file2 = new File(file2Path);
        this.storage1_stream = ResourceUtil_BinaryIdentical3Test.mockStorage(new FileInputStreamProvider(this.file1));
        this.storage1_stream2 = ResourceUtil_BinaryIdentical3Test.mockStorage(new FileInputStreamProvider(this.file1));
        this.storage2_stream = ResourceUtil_BinaryIdentical3Test.mockStorage(new FileInputStreamProvider(this.file2));
    }

    @Test
    public void testBinaryIdentical_2_sameData() throws IOException {
        IStorage storage1_stream3 = ResourceUtil_BinaryIdentical3Test.mockStorage(new FileInputStreamProvider(this.file1));
        Assert.assertTrue((boolean)ResourceUtil.binaryIdentical((IStorage)this.storage1_stream, (IStorage)this.storage1_stream2, (IStorage)storage1_stream3));
    }

    @Test
    public void testBinaryIdentical_2_differentData() {
        Assert.assertFalse((boolean)ResourceUtil.binaryIdentical((IStorage)this.storage1_stream, (IStorage)this.storage2_stream, (IStorage)this.storage1_stream));
    }

    @Test
    public void testBinaryIdentical_2_differentData_reordered() {
        Assert.assertFalse((boolean)ResourceUtil.binaryIdentical((IStorage)this.storage1_stream, (IStorage)this.storage1_stream2, (IStorage)this.storage2_stream));
    }

    @Test
    public void testBinaryIdentical_2_sameData_differentBuffers() throws IOException {
        IStorage storage1 = ResourceUtil_BinaryIdentical3Test.mockStorage(new BufferedInputStreamProvider(this.file1, 16384));
        IStorage storage2 = ResourceUtil_BinaryIdentical3Test.mockStorage(new BufferedInputStreamProvider(this.file1, 8192));
        IStorage storage3 = ResourceUtil_BinaryIdentical3Test.mockStorage(new BufferedInputStreamProvider(this.file1, 1021));
        Assert.assertTrue((boolean)ResourceUtil.binaryIdentical((IStorage)storage1, (IStorage)storage2, (IStorage)storage3));
    }

    @Test
    public void testBinaryIdentical_2_sameData_sameBuffers() throws IOException {
        IStorage storage1 = ResourceUtil_BinaryIdentical3Test.mockStorage(new BufferedInputStreamProvider(this.file1, 16384));
        IStorage storage2 = ResourceUtil_BinaryIdentical3Test.mockStorage(new BufferedInputStreamProvider(this.file1, 16384));
        IStorage storage3 = ResourceUtil_BinaryIdentical3Test.mockStorage(new BufferedInputStreamProvider(this.file1, 16384));
        Assert.assertTrue((boolean)ResourceUtil.binaryIdentical((IStorage)storage1, (IStorage)storage2, (IStorage)storage3));
    }

    @Test
    public void testBinaryIdentical_2_differentData_sameBuffers() throws IOException {
        IStorage storage1 = ResourceUtil_BinaryIdentical3Test.mockStorage(new BufferedInputStreamProvider(this.file1, 16384));
        IStorage storage2 = ResourceUtil_BinaryIdentical3Test.mockStorage(new BufferedInputStreamProvider(this.file2, 16384));
        IStorage storage3 = ResourceUtil_BinaryIdentical3Test.mockStorage(new BufferedInputStreamProvider(this.file2, 16384));
        Assert.assertFalse((boolean)ResourceUtil.binaryIdentical((IStorage)storage1, (IStorage)storage2, (IStorage)storage3));
    }

    @Test
    public void testBinaryIdentical_2_mixedTypes() throws IOException {
        IStorage storage1Buffered = ResourceUtil_BinaryIdentical3Test.mockStorage(new BufferedInputStreamProvider(this.file1, 1024));
        IStorage storage1Buffered2 = ResourceUtil_BinaryIdentical3Test.mockStorage(new BufferedInputStreamProvider(this.file1, 1024));
        IStorage storage2Buffered = ResourceUtil_BinaryIdentical3Test.mockStorage(new BufferedInputStreamProvider(this.file2, 1024));
        Assert.assertTrue((boolean)ResourceUtil.binaryIdentical((IStorage)storage1Buffered2, (IStorage)this.storage1_stream, (IStorage)storage1Buffered));
        Assert.assertFalse((boolean)ResourceUtil.binaryIdentical((IStorage)this.storage1_stream, (IStorage)storage2Buffered, (IStorage)storage1Buffered));
    }

    @Test
    public void testFalseIfCoreException() throws Exception {
        ByteArrayInputStreamProvider input1 = new ByteArrayInputStreamProvider(new byte[]{12, 64});
        ByteArrayInputStreamProvider input3 = new ByteArrayInputStreamProvider(new byte[]{12, 64});
        IStorage storage2 = (IStorage)Mockito.mock(IStorage.class);
        Mockito.when((Object)storage2.getContents()).thenThrow(new Throwable[]{new CoreException(Status.CANCEL_STATUS)});
        Assert.assertFalse((boolean)ResourceUtil.binaryIdentical((IStorage)ResourceUtil_BinaryIdentical3Test.mockStorage(input1), (IStorage)storage2, (IStorage)ResourceUtil_BinaryIdentical3Test.mockStorage(input3)));
    }

    @Test
    public void testFalseIfIOException() throws IOException {
        ByteArrayInputStreamProvider input1 = new ByteArrayInputStreamProvider(new byte[]{12, 64});
        ByteArrayInputStreamProvider input3 = new ByteArrayInputStreamProvider(new byte[]{12, 64});
        InputStream input2 = (InputStream)Mockito.mock(InputStream.class);
        Mockito.when((Object)input2.read((byte[])Matchers.any(byte[].class), Matchers.anyInt(), Matchers.anyInt())).thenThrow(new Throwable[]{new IOException()});
        IStorage mockStorage = (IStorage)Mockito.mock(IStorage.class);
        try {
            Mockito.when((Object)mockStorage.getContents()).thenReturn((Object)input2);
            Mockito.when((Object)mockStorage.isReadOnly()).thenReturn((Object)true);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        Assert.assertFalse((boolean)ResourceUtil.binaryIdentical((IStorage)ResourceUtil_BinaryIdentical3Test.mockStorage(input1), (IStorage)mockStorage, (IStorage)ResourceUtil_BinaryIdentical3Test.mockStorage(input3)));
    }
}

