/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.ui.internal.structuremergeviewer;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.eventbus.Subscribe;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.compare.CompareViewerPane;
import org.eclipse.compare.INavigatable;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.emf.compare.ide.ui.internal.EMFCompareIDEUIPlugin;
import org.eclipse.emf.compare.ide.ui.internal.configuration.EMFCompareConfiguration;
import org.eclipse.emf.compare.ide.ui.internal.structuremergeviewer.actions.CollapseAllModelAction;
import org.eclipse.emf.compare.ide.ui.internal.structuremergeviewer.actions.DropDownMergeMenuAction;
import org.eclipse.emf.compare.ide.ui.internal.structuremergeviewer.actions.ExpandAllModelAction;
import org.eclipse.emf.compare.ide.ui.internal.structuremergeviewer.actions.MergeAction;
import org.eclipse.emf.compare.ide.ui.internal.structuremergeviewer.actions.MergeAllNonConflictingAction;
import org.eclipse.emf.compare.ide.ui.internal.structuremergeviewer.actions.SaveComparisonModelAction;
import org.eclipse.emf.compare.ide.ui.internal.structuremergeviewer.actions.SelectDiffAction;
import org.eclipse.emf.compare.ide.ui.internal.util.CompareHandlerService;
import org.eclipse.emf.compare.internal.merge.MergeMode;
import org.eclipse.emf.compare.merge.IMerger;
import org.eclipse.emf.compare.rcp.EMFCompareRCPPlugin;
import org.eclipse.emf.compare.rcp.ui.EMFCompareRCPUIPlugin;
import org.eclipse.emf.compare.rcp.ui.internal.configuration.IAdapterFactoryChange;
import org.eclipse.emf.compare.rcp.ui.internal.configuration.ICompareEditingDomainChange;
import org.eclipse.emf.compare.rcp.ui.internal.configuration.IComparisonAndScopeChange;
import org.eclipse.emf.compare.rcp.ui.internal.configuration.IEMFCompareConfiguration;
import org.eclipse.emf.compare.rcp.ui.internal.structuremergeviewer.actions.FilterActionMenu;
import org.eclipse.emf.compare.rcp.ui.internal.structuremergeviewer.actions.GroupActionMenu;
import org.eclipse.emf.compare.rcp.ui.internal.structuremergeviewer.filters.StructureMergeViewerFilter;
import org.eclipse.emf.compare.rcp.ui.internal.structuremergeviewer.groups.StructureMergeViewerGrouper;
import org.eclipse.emf.compare.rcp.ui.internal.util.SWTUtil;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.ContributionManager;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.bindings.Binding;
import org.eclipse.jface.bindings.TriggerSequence;
import org.eclipse.jface.bindings.keys.KeyBinding;
import org.eclipse.jface.bindings.keys.KeySequence;
import org.eclipse.jface.bindings.keys.ParseException;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.keys.IBindingService;
import org.eclipse.ui.menus.IMenuService;

public class CompareToolBar
implements ISelectionChangedListener {
    private static final String COMPARE_EDITOR_SCOPE_ID = "org.eclipse.compare.compareEditorScope";
    private static final String DEFAULT_ACCELERATOR_SCHEME_ID = "org.eclipse.ui.defaultAcceleratorConfiguration";
    private static final Map<String, String> COMPARE_BINDINGS;
    private final GroupActionMenu groupActionMenu;
    private final FilterActionMenu filterActionMenu;
    private final List<MergeAction> mergeActions;
    private final List<MergeAllNonConflictingAction> mergeAllNonConflictingActions;
    private final EMFCompareConfiguration compareConfiguration;
    private final ToolBarManager toolbarManager;
    private boolean doOnce;
    private DropDownMergeMenuAction dropDownMergeMenuAction;
    private List<SelectDiffAction> selectDiffActions = new ArrayList<SelectDiffAction>();

    static {
        HashMap bindings = Maps.newHashMap();
        bindings.put("org.eclipse.compare.selectNextChange", "M3+ARROW_DOWN");
        bindings.put("org.eclipse.compare.selectPreviousChange", "M3+ARROW_UP");
        bindings.put("org.eclipse.compare.copyLeftToRight", "M3+ARROW_RIGHT");
        bindings.put("org.eclipse.compare.copyRightToLeft", "M3+ARROW_LEFT");
        bindings.put("org.eclipse.compare.copyAllLeftToRight", "M2+M3+ARROW_RIGHT");
        bindings.put("org.eclipse.compare.copyAllRightToLeft", "M2+M3+ARROW_LEFT");
        COMPARE_BINDINGS = Collections.unmodifiableMap(bindings);
    }

    public CompareToolBar(ToolBarManager toolbarManager, StructureMergeViewerGrouper viewerGrouper, StructureMergeViewerFilter viewerFilter, EMFCompareConfiguration compareConfiguration) {
        this.toolbarManager = (ToolBarManager)Preconditions.checkNotNull((Object)toolbarManager);
        this.compareConfiguration = (EMFCompareConfiguration)((Object)Preconditions.checkNotNull((Object)((Object)compareConfiguration)));
        this.mergeActions = Lists.newArrayListWithCapacity((int)2);
        this.mergeAllNonConflictingActions = Lists.newArrayListWithCapacity((int)2);
        this.groupActionMenu = compareConfiguration.getBooleanProperty("org.eclipse.emf.compare.ide.ui.DISPLAY_GROUP_PROVIDERS", true) ? new GroupActionMenu((StructureMergeViewerGrouper)Preconditions.checkNotNull((Object)viewerGrouper), EMFCompareRCPUIPlugin.getDefault().getDifferenceGroupProviderRegistry()) : null;
        this.filterActionMenu = compareConfiguration.getBooleanProperty("org.eclipse.emf.compare.ide.ui.DISPLAY_FILTERS", true) ? new FilterActionMenu((StructureMergeViewerFilter)Preconditions.checkNotNull((Object)viewerFilter), EMFCompareRCPUIPlugin.getDefault().getDifferenceFilterRegistry()) : null;
    }

    public final void initToolbar(AbstractTreeViewer viewer, INavigatable nav, CompareHandlerService handlerService) {
        if (!this.doOnce) {
            this.compareConfiguration.getEventBus().register((Object)this);
            if (PlatformUI.isWorkbenchRunning()) {
                final IMenuService menuService = this.getService(IMenuService.class);
                if (menuService != null) {
                    menuService.populateContributionManager((ContributionManager)this.toolbarManager, "toolbar:org.eclipse.emf.compare.structuremergeviewer.toolbar");
                    ToolBar toolbar = this.toolbarManager.getControl();
                    if (toolbar != null) {
                        toolbar.addDisposeListener(new DisposeListener(){

                            public void widgetDisposed(DisposeEvent e) {
                                menuService.releaseContributions((ContributionManager)CompareToolBar.this.toolbarManager);
                            }
                        });
                    }
                }
                this.registerCompareBindings();
            }
            boolean leftEditable = this.compareConfiguration.isLeftEditable();
            boolean rightEditable = this.compareConfiguration.isRightEditable();
            EnumSet<MergeMode> modes = rightEditable && leftEditable ? EnumSet.of(MergeMode.RIGHT_TO_LEFT, MergeMode.LEFT_TO_RIGHT) : EnumSet.of(MergeMode.ACCEPT, MergeMode.REJECT);
            if (rightEditable || leftEditable) {
                this.dropDownMergeMenuAction = new DropDownMergeMenuAction(this.compareConfiguration, modes);
                this.toolbarManager.add((IAction)this.dropDownMergeMenuAction);
                for (MergeMode mode : modes) {
                    this.toolbarManager.add((IAction)this.createMergeAction(mode, this.compareConfiguration, nav));
                }
                for (MergeMode mode : modes) {
                    this.toolbarManager.add((IAction)this.createMergeAllNonConflictingAction(mode, this.compareConfiguration));
                }
            }
            this.toolbarManager.add((IContributionItem)new Separator());
            this.selectDiffActions.add(new SelectDiffAction(nav, 1));
            this.selectDiffActions.add(new SelectDiffAction(nav, 2));
            if (this.compareConfiguration.getBooleanProperty("org.eclipse.emf.compare.ide.ui.DISPLAY_SELECT_UNRESOLVED_DIFF_ACTIONS", true)) {
                this.selectDiffActions.add(new SelectDiffAction(nav, 80));
                this.selectDiffActions.add(new SelectDiffAction(nav, 81));
            }
            for (SelectDiffAction selectDiffAction : this.selectDiffActions) {
                this.toolbarManager.add((IAction)selectDiffAction);
            }
            this.toolbarManager.add((IContributionItem)new Separator());
            this.toolbarManager.add((IAction)new ExpandAllModelAction(viewer));
            this.toolbarManager.add((IAction)new CollapseAllModelAction(viewer));
            this.toolbarManager.add((IContributionItem)new Separator());
            if (this.groupActionMenu != null) {
                this.toolbarManager.add((IAction)this.groupActionMenu);
                this.groupActionMenu.updateMenu(this.compareConfiguration.getComparisonScope(), this.compareConfiguration.getComparison());
            }
            if (this.filterActionMenu != null) {
                this.toolbarManager.add((IAction)this.filterActionMenu);
                this.filterActionMenu.updateMenu(this.compareConfiguration.getComparisonScope(), this.compareConfiguration.getComparison());
            }
            this.toolbarManager.add((IContributionItem)new Separator());
            if (this.compareConfiguration.getBooleanProperty("org.eclipse.emf.compare.ide.ui.DISPLAY_SAVE_ACTION", true)) {
                this.toolbarManager.add((IAction)new SaveComparisonModelAction(this.compareConfiguration));
            }
            Arrays.stream(this.toolbarManager.getItems()).filter(item -> item instanceof ActionContributionItem && ((ActionContributionItem)item).getAction().getActionDefinitionId() != null).map(ActionContributionItem.class::cast).forEach(item -> this.registerBinding((ActionContributionItem)item, viewer, handlerService));
            this.toolbarManager.update(true);
            this.doOnce = true;
        }
    }

    public ToolBarManager getToolBarManager() {
        return this.toolbarManager;
    }

    private void registerCompareBindings() {
        IBindingService bindingService = this.getService(IBindingService.class);
        if (this.isDefaultAcceleratorSchemeActive()) {
            ICommandService commandService = this.getService(ICommandService.class);
            ArrayList newBindings = Lists.newArrayList();
            for (Map.Entry<String, String> entry : COMPARE_BINDINGS.entrySet()) {
                KeySequence keySequence;
                String id = entry.getKey();
                if (bindingService.getActiveBindingsFor(id).length != 0) continue;
                Command command = commandService.getCommand(id);
                ParameterizedCommand parameterizedCommand = ParameterizedCommand.generateCommand((Command)command, Collections.emptyMap());
                try {
                    keySequence = KeySequence.getInstance((String)entry.getValue());
                }
                catch (ParseException e) {
                    continue;
                }
                KeyBinding binding = new KeyBinding(keySequence, parameterizedCommand, DEFAULT_ACCELERATOR_SCHEME_ID, COMPARE_EDITOR_SCOPE_ID, null, null, null, 1);
                newBindings.add(binding);
            }
            if (!newBindings.isEmpty()) {
                ArrayList bindings = Lists.newArrayList((Object[])bindingService.getBindings());
                bindings.addAll(newBindings);
                try {
                    bindingService.savePreferences(bindingService.getActiveScheme(), bindings.toArray(new Binding[bindings.size()]));
                }
                catch (IOException e) {
                    EMFCompareIDEUIPlugin.getDefault().log(e);
                }
            }
        }
    }

    private boolean isDefaultAcceleratorSchemeActive() {
        IBindingService bindingService = this.getService(IBindingService.class);
        return bindingService.getActiveScheme() != null && DEFAULT_ACCELERATOR_SCHEME_ID.equals(bindingService.getActiveScheme().getId());
    }

    private <T> T getService(Class<T> serviceClass) {
        return (T)PlatformUI.getWorkbench().getService(serviceClass);
    }

    private void registerBinding(ActionContributionItem item, AbstractTreeViewer viewer, CompareHandlerService handlerService) {
        IAction action = item.getAction();
        String actionDefinitionId = action.getActionDefinitionId();
        ActionWrapper actionWrapper = new ActionWrapper(action, viewer);
        actionWrapper.setActionDefinitionId(actionDefinitionId);
        handlerService.setGlobalActionHandler(actionDefinitionId, (IAction)actionWrapper);
        IBindingService bindingService = this.getService(IBindingService.class);
        if (bindingService != null) {
            TriggerSequence[] triggerSequenceArray = bindingService.getActiveBindingsFor(actionDefinitionId);
            int n = triggerSequenceArray.length;
            int n2 = 0;
            while (n2 < n) {
                ParameterizedCommand parameterizedCommand;
                String id;
                TriggerSequence triggerSequence = triggerSequenceArray[n2];
                Binding binding = bindingService.getPerfectMatch(triggerSequence);
                if (binding != null && !actionDefinitionId.equals(id = (parameterizedCommand = binding.getParameterizedCommand()).getId())) {
                    actionWrapper.setActionDefinitionId(id);
                    handlerService.setGlobalActionHandler(id, (IAction)actionWrapper);
                }
                ++n2;
            }
        }
    }

    private MergeAction createMergeAction(MergeMode mergeMode, EMFCompareConfiguration cc, INavigatable nav) {
        IMerger.Registry mergerRegistry = EMFCompareRCPPlugin.getDefault().getMergerRegistry();
        MergeAction mergeAction = new MergeAction(cc, mergerRegistry, mergeMode, nav);
        this.mergeActions.add(mergeAction);
        if (mergeMode == MergeMode.RIGHT_TO_LEFT || mergeMode == MergeMode.ACCEPT) {
            mergeAction.setActionDefinitionId("org.eclipse.compare.copyRightToLeft");
        } else {
            mergeAction.setActionDefinitionId("org.eclipse.compare.copyLeftToRight");
        }
        return mergeAction;
    }

    private MergeAction createMergeAllNonConflictingAction(MergeMode mergeMode, IEMFCompareConfiguration cc) {
        IMerger.Registry mergerRegistry = EMFCompareRCPPlugin.getDefault().getMergerRegistry();
        MergeAllNonConflictingAction mergeAction = new MergeAllNonConflictingAction(cc, cc.getComparison(), mergerRegistry, mergeMode);
        this.mergeAllNonConflictingActions.add(mergeAction);
        if (mergeMode == MergeMode.RIGHT_TO_LEFT || mergeMode == MergeMode.ACCEPT) {
            mergeAction.setActionDefinitionId("org.eclipse.compare.copyAllRightToLeft");
        } else {
            mergeAction.setActionDefinitionId("org.eclipse.compare.copyAllLeftToRight");
        }
        return mergeAction;
    }

    public void dispose() {
        if (this.dropDownMergeMenuAction != null) {
            this.dropDownMergeMenuAction.dispose();
            this.dropDownMergeMenuAction = null;
        }
        for (SelectDiffAction selectDiffAction : this.selectDiffActions) {
            selectDiffAction.dispose();
        }
        this.selectDiffActions.clear();
        this.toolbarManager.removeAll();
        if (this.doOnce) {
            this.compareConfiguration.getEventBus().unregister((Object)this);
        }
        this.doOnce = false;
    }

    public void selectionChanged(SelectionChangedEvent event) {
        for (MergeAction mergeAction : this.mergeActions) {
            mergeAction.selectionChanged(event);
        }
        for (MergeAllNonConflictingAction mergeAllNonConflictingAction : this.mergeAllNonConflictingActions) {
            mergeAllNonConflictingAction.selectionChanged(event);
        }
    }

    @Subscribe
    public void editingDomainChange(ICompareEditingDomainChange event) {
        for (MergeAction mergeAction : this.mergeActions) {
            mergeAction.setEditingDomain(event.getNewValue());
        }
        for (MergeAction mergeAction : this.mergeAllNonConflictingActions) {
            mergeAction.setEditingDomain(event.getNewValue());
        }
    }

    @Subscribe
    public void adapterFactoryChange(IAdapterFactoryChange event) {
        for (MergeAction mergeAction : this.mergeActions) {
            mergeAction.setAdapterFactory(event.getNewValue());
        }
        for (MergeAction mergeAction : this.mergeAllNonConflictingActions) {
            mergeAction.setAdapterFactory(event.getNewValue());
        }
    }

    @Subscribe
    public void comparisonAndScopeChange(final IComparisonAndScopeChange event) {
        SWTUtil.safeAsyncExec((Runnable)new Runnable(){

            @Override
            public void run() {
                if (CompareToolBar.this.filterActionMenu != null) {
                    CompareToolBar.this.filterActionMenu.updateMenu(event.getNewScope(), event.getNewComparison());
                }
                if (CompareToolBar.this.groupActionMenu != null) {
                    CompareToolBar.this.groupActionMenu.updateMenu(event.getNewScope(), event.getNewComparison());
                }
            }
        });
        for (MergeAllNonConflictingAction mergeAction : this.mergeAllNonConflictingActions) {
            mergeAction.setComparison(event.getNewComparison());
        }
    }

    public void setEnabled(boolean enable) {
        ToolBar toolbar = this.toolbarManager.getControl();
        if (toolbar != null) {
            toolbar.setEnabled(enable);
        }
    }

    public boolean isEnabled() {
        ToolBar toolbar = this.toolbarManager.getControl();
        return toolbar != null && toolbar.isEnabled();
    }

    private final class ActionWrapper
    extends Action {
        private final AbstractTreeViewer viewer;
        private final IAction action;

        private ActionWrapper(IAction action, AbstractTreeViewer viewer) {
            super(action.getText());
            this.viewer = viewer;
            this.action = action;
        }

        public void run() {
            Composite composite = this.viewer.getControl().getParent();
            Control focusControl = composite.getDisplay().getFocusControl();
            if (focusControl != null) {
                Composite parent = focusControl.getParent();
                while (parent != null && parent != composite) {
                    ToolBarManager toolBarManager = CompareViewerPane.getToolBarManager((Composite)parent);
                    if (toolBarManager != null) {
                        IContributionItem[] iContributionItemArray = toolBarManager.getItems();
                        int n = iContributionItemArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IContributionItem otherContributionItem = iContributionItemArray[n2];
                            if (otherContributionItem instanceof ActionContributionItem) {
                                ActionContributionItem otherActionContributionItem = (ActionContributionItem)otherContributionItem;
                                IAction contributedAction = otherActionContributionItem.getAction();
                                String actionDefinitionId = contributedAction.getActionDefinitionId();
                                if (this.action.getActionDefinitionId().equals(actionDefinitionId)) {
                                    if (contributedAction.isEnabled()) {
                                        contributedAction.run();
                                    }
                                    return;
                                }
                            }
                            ++n2;
                        }
                    }
                    parent = parent.getParent();
                }
            }
            if (this.action.isEnabled()) {
                this.action.run();
            }
        }
    }
}

