/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.ui.internal.logical.resolver;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.Callable;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.compare.ide.ui.internal.logical.resolver.AbstractResolution;
import org.eclipse.emf.compare.ide.ui.internal.logical.resolver.IResolutionContext;
import org.eclipse.emf.compare.ide.ui.internal.logical.resolver.IResourceDependencyLocalResolver;
import org.eclipse.emf.compare.ide.utils.StorageTraversal;

public class LocalModelResolution
extends AbstractResolution {
    private final IResourceDependencyLocalResolver resolver;

    public LocalModelResolution(IResolutionContext context, IProgressMonitor monitor) {
        super(context, monitor);
        this.resolver = context.getLocalResolver();
    }

    public StorageTraversal run(final IResource start) throws InterruptedException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"run() - START");
        }
        if (!(start instanceof IFile)) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"run() - FINISH");
            }
            return new StorageTraversal(new LinkedHashSet());
        }
        return this.call(new Callable<StorageTraversal>(){

            @Override
            public StorageTraversal call() throws InterruptedException {
                LocalModelResolution.this.resolver.updateDependencies((IProgressMonitor)LocalModelResolution.this.monitor, LocalModelResolution.this.diagnostic, (IFile)start);
                if (LocalModelResolution.this.monitor.isCanceled()) {
                    throw new OperationCanceledException();
                }
                Set<IStorage> traversalSet = LocalModelResolution.this.resolveTraversal((IFile)start, Collections.<URI>emptySet());
                StorageTraversal traversal = new StorageTraversal(traversalSet, (Diagnostic)LocalModelResolution.this.diagnostic.getDiagnostic());
                if (LocalModelResolution.this.logger.isDebugEnabled()) {
                    LocalModelResolution.this.logger.debug((Object)"run() - FINISH");
                }
                return traversal;
            }
        });
    }
}

