/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.oxm;

import java.io.UnsupportedEncodingException;
import java.util.StringTokenizer;
import javax.xml.namespace.QName;
import org.eclipse.persistence.internal.oxm.XPathPredicate;
import org.eclipse.persistence.oxm.XMLField;

public class XPathFragment {
    public static final XPathFragment TEXT_FRAGMENT = new XPathFragment("text()");
    public static final String SELF_XPATH = ".";
    public static final XPathFragment SELF_FRAGMENT = new XPathFragment(".");
    public static final XPathFragment ANY_FRAGMENT = null;
    private XPathFragment nextFragment;
    private XMLField xmlField;
    private String xpath;
    private boolean hasAttribute = false;
    private boolean hasText = false;
    private boolean hasNamespace = false;
    private boolean containsIndex = false;
    private int indexValue = -1;
    private boolean shouldExecuteSelectNodes = false;
    private String shortName;
    private byte[] shortNameBytes;
    private String prefix;
    private String localName;
    private String namespaceURI;
    private QName qname;
    protected boolean nameIsText = false;
    protected boolean isSelfFragment = false;
    private QName leafElementType;
    private boolean generatedPrefix = false;
    private XPathPredicate predicate;

    public XPathPredicate getPredicate() {
        return this.predicate;
    }

    public void setPredicate(XPathPredicate condition) {
        this.predicate = condition;
    }

    public XPathFragment(String xpathString) {
        this.setXPath(xpathString);
    }

    public XPathFragment() {
    }

    public XPathFragment getNextFragment() {
        return this.nextFragment;
    }

    public void setNextFragment(XPathFragment nextFragment) {
        this.nextFragment = nextFragment;
    }

    public void setXPath(String xpathString) {
        this.xpath = xpathString;
        this.shortName = xpathString;
        if (xpathString.length() > 0) {
            if (this.xpath.indexOf(91) != -1 && this.xpath.indexOf(93) == -1) {
                this.setShouldExecuteSelectNodes(true);
                return;
            }
            if (this.xpath.indexOf("::") != -1) {
                this.setShouldExecuteSelectNodes(true);
                return;
            }
            if (xpathString.charAt(0) == '@') {
                this.hasAttribute = true;
                this.shortName = xpathString.substring(1).intern();
                this.indexValue = this.hasIndex(xpathString);
                this.setupNamespaceInformation(this.shortName);
                return;
            }
            if (xpathString.charAt(0) == '/') {
                this.setShouldExecuteSelectNodes(true);
                this.shortName = xpathString.substring(xpathString.lastIndexOf(47) + 1).intern();
                this.indexValue = this.hasIndex(xpathString);
                this.setupNamespaceInformation(this.shortName);
                return;
            }
        }
        if (xpathString.equals("text()")) {
            this.nameIsText = true;
            this.shortName = xpathString.intern();
            return;
        }
        this.nameIsText = false;
        if (xpathString.equals(SELF_XPATH)) {
            this.isSelfFragment = true;
            this.shortName = xpathString.intern();
            return;
        }
        this.indexValue = this.hasIndex(xpathString);
        this.setupNamespaceInformation(this.shortName);
    }

    private void setupNamespaceInformation(String xpathString) {
        int nsindex = xpathString.indexOf(58);
        if (nsindex != -1) {
            this.hasNamespace = true;
            this.localName = xpathString.substring(nsindex + 1).intern();
            this.prefix = xpathString.substring(0, nsindex).intern();
        } else {
            this.localName = xpathString.intern();
        }
    }

    public boolean isAttribute() {
        return this.hasAttribute;
    }

    public void setAttribute(boolean isAttribute) {
        this.hasAttribute = isAttribute;
    }

    public String getShortName() {
        return this.shortName;
    }

    public byte[] getShortNameBytes() {
        if (null == this.shortNameBytes) {
            try {
                this.shortNameBytes = this.shortName.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        return this.shortNameBytes;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public String getLocalName() {
        return this.localName;
    }

    public void setLocalName(String localName) {
        this.localName = localName;
    }

    public String getNamespaceURI() {
        return this.namespaceURI;
    }

    public void setNamespaceURI(String namespaceURI) {
        this.namespaceURI = this.isSelfFragment || namespaceURI != null && namespaceURI.length() == 0 ? null : namespaceURI;
    }

    public QName getQName() {
        return this.qname;
    }

    public void setQName(QName q) {
        this.qname = q;
    }

    private int hasIndex(String xpathString) {
        int index = -1;
        int startindex = xpathString.lastIndexOf(91);
        if (startindex != -1 && xpathString.lastIndexOf(93) != -1) {
            StringTokenizer st = new StringTokenizer(xpathString, "[]");
            String element = st.nextToken();
            while (st.hasMoreTokens()) {
                String indexString = st.nextToken();
                try {
                    index = Integer.valueOf(indexString);
                    this.setContainsIndex(true);
                }
                catch (NumberFormatException e) {
                    StringTokenizer st2 = new StringTokenizer(indexString, "=");
                    if (2 == st2.countTokens()) {
                        XPathFragment xPathFragment = new XPathFragment(st2.nextToken());
                        String value = st2.nextToken();
                        value = value.substring(1, value.length() - 1);
                        this.predicate = new XPathPredicate(xPathFragment, value);
                    } else {
                        this.setContainsIndex(true);
                    }
                    this.setShouldExecuteSelectNodes(true);
                }
            }
            this.shortName = element;
        } else {
            index = -1;
        }
        return index;
    }

    public int getIndexValue() {
        return this.indexValue;
    }

    public void setIndexValue(int indexValue) {
        this.indexValue = indexValue;
    }

    public String getXPath() {
        return this.xpath;
    }

    public boolean hasNamespace() {
        return this.hasNamespace;
    }

    public boolean isSelfFragment() {
        return this.isSelfFragment;
    }

    public boolean nameIsText() {
        return this.nameIsText;
    }

    public void setHasText(boolean hasText) {
        this.hasText = hasText;
    }

    public boolean getHasText() {
        return this.hasText;
    }

    public void setContainsIndex(boolean containsIndex) {
        this.containsIndex = containsIndex;
    }

    public boolean containsIndex() {
        return this.containsIndex;
    }

    public void setShouldExecuteSelectNodes(boolean newShouldExecuteSelectNodes) {
        this.shouldExecuteSelectNodes = newShouldExecuteSelectNodes;
    }

    public boolean shouldExecuteSelectNodes() {
        return this.shouldExecuteSelectNodes;
    }

    public boolean equals(Object object) {
        try {
            if (null == object) {
                return false;
            }
            if (this == object) {
                return true;
            }
            XPathFragment xPathFragment = (XPathFragment)object;
            if (null == this.predicate && null != xPathFragment.getPredicate()) {
                return false;
            }
            if (null != this.predicate && !this.predicate.equals(xPathFragment.getPredicate())) {
                return false;
            }
            return (this.nameIsText && xPathFragment.nameIsText() || this.localName == xPathFragment.getLocalName() || this.localName != null && this.localName.equals(xPathFragment.getLocalName())) && (this.namespaceURI == xPathFragment.getNamespaceURI() || this.namespaceURI != null && this.namespaceURI.equals(xPathFragment.getNamespaceURI())) && this.indexValue == xPathFragment.getIndexValue() && this.nameIsText == xPathFragment.nameIsText();
        }
        catch (ClassCastException e) {
            return false;
        }
    }

    public boolean qNameEquals(Object object) {
        try {
            if (this == object) {
                return true;
            }
            XPathFragment xPathFragment = (XPathFragment)object;
            return (this.localName == xPathFragment.getLocalName() || this.localName != null && this.localName.equals(xPathFragment.getLocalName())) && (this.namespaceURI == xPathFragment.getNamespaceURI() || this.namespaceURI != null && this.namespaceURI.equals(xPathFragment.getNamespaceURI())) && this.nameIsText == xPathFragment.nameIsText();
        }
        catch (ClassCastException e) {
            return false;
        }
    }

    public int hashCode() {
        if (null == this.localName) {
            return 1;
        }
        return this.localName.hashCode();
    }

    public QName getLeafElementType() {
        return this.leafElementType;
    }

    public boolean hasLeafElementType() {
        return this.getLeafElementType() != null;
    }

    public void setLeafElementType(QName type) {
        this.leafElementType = type;
    }

    public void setGeneratedPrefix(boolean isGenerated) {
        this.generatedPrefix = isGenerated;
    }

    public boolean isGeneratedPrefix() {
        return this.generatedPrefix;
    }

    public XMLField getXMLField() {
        return this.xmlField;
    }

    public void setXMLField(XMLField field) {
        this.xmlField = field;
    }
}

