/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hawk.ui2.dialog;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.hawk.osgiserver.HModel;
import org.eclipse.hawk.osgiserver.HModelSchedulingRule;
import org.eclipse.hawk.ui2.Activator;
import org.eclipse.hawk.ui2.dialog.HStateBasedDialog;
import org.eclipse.hawk.ui2.util.TypeCascadeSelectionAdapter;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.FilteredResourcesSelectionDialog;
import org.osgi.framework.FrameworkUtil;

final class HDerivedAttributeDialog
extends HStateBasedDialog {
    private static final String DEFAULT_TYPE = "TypeDeclaration";
    private static final String DEFAULT_NAME = "isSingleton";
    private static final String DEFAULT_DERIVATION_LOGIC = "return self.bodyDeclarations.exists(md:MethodDeclaration|md.modifiers.exists(mod:Modifier|mod.public==true) and md.modifiers.exists(mod:Modifier|mod.static==true) and md.returnType.isTypeOf(SimpleType) and md.returnType.name.fullyQualifiedName == self.name.fullyQualifiedName);";
    private Combo cmbMetamodel;
    private Combo cmbType;
    private Text txtName;
    private Combo cmbValueType;
    private Combo cmbIsMany;
    private Combo cmbIsOrdered;
    private Combo cmbIsUnique;
    private Combo cmbDerivationLanguage;
    private Text txtDerivationLogic;
    private Text txtErrorMessages;

    HDerivedAttributeDialog(HModel hawkModel, Shell parentShell) {
        super(hawkModel, parentShell);
    }

    private String getDerivationLanguage() {
        return this.cmbDerivationLanguage.getText().trim();
    }

    private String getDerivationLogic() {
        return this.txtDerivationLogic.getText().trim();
    }

    private String getMetamodelURI() {
        return this.cmbMetamodel.getText().trim();
    }

    private boolean isMany() {
        return Boolean.parseBoolean(this.cmbIsMany.getText().trim());
    }

    private boolean isOrdered() {
        return Boolean.parseBoolean(this.cmbIsOrdered.getText().trim());
    }

    private boolean isUnique() {
        return Boolean.parseBoolean(this.cmbIsUnique.getText().trim());
    }

    private String getTargetType() {
        return this.cmbType.getText().trim();
    }

    private String getPropertyName() {
        return this.txtName.getText().trim();
    }

    private String getValueType() {
        return this.cmbValueType.getText().trim();
    }

    private boolean check() {
        String error;
        String derivationLogic;
        String derivationLanguage = this.getDerivationLanguage();
        List l = this.hawkModel.validateExpression(derivationLanguage, derivationLogic = this.getDerivationLogic());
        if (l.size() > 0) {
            error = "";
            int i = 0;
            while (i < l.size()) {
                String s = (String)l.get(i);
                error = String.valueOf(error) + (i + 1) + ") " + s + "\n";
                ++i;
            }
        } else {
            error = "";
        }
        this.txtErrorMessages.setText(error);
        String uri = this.getMetamodelURI();
        String type = this.getTargetType();
        String name = this.getPropertyName();
        String valueType = this.getValueType();
        return !uri.equals("") && !type.equals("") && !name.equals("") && !valueType.equals("") && !derivationLanguage.equals("") && !derivationLogic.equals("") && l.size() == 0;
    }

    protected void okPressed() {
        if (this.check()) {
            final String metamodelURI = this.getMetamodelURI();
            final String targetType = this.getTargetType();
            final String propertyName = this.getPropertyName();
            final String valueType = this.getValueType();
            final boolean bIsMany = this.isMany();
            final boolean bIsOrdered = this.isOrdered();
            final boolean bIsUnique = this.isUnique();
            final String derivationLanguage = this.getDerivationLanguage();
            final String derivationLogic = this.getDerivationLogic();
            String jobName = "Adding derived property " + propertyName + " to " + this.hawkModel.getName();
            Job addDerivedJob = new Job(jobName){

                protected IStatus run(IProgressMonitor monitor) {
                    String symbolicName = FrameworkUtil.getBundle(((Object)((Object)this)).getClass()).getSymbolicName();
                    try {
                        HDerivedAttributeDialog.this.hawkModel.addDerivedAttribute(metamodelURI, targetType, propertyName, valueType, Boolean.valueOf(bIsMany), Boolean.valueOf(bIsOrdered), Boolean.valueOf(bIsUnique), derivationLanguage, derivationLogic);
                    }
                    catch (Exception e1) {
                        return new Status(4, symbolicName, "Failed", (Throwable)e1);
                    }
                    return new Status(0, symbolicName, "Done");
                }
            };
            addDerivedJob.setRule((ISchedulingRule)new HModelSchedulingRule(this.hawkModel));
            addDerivedJob.schedule();
        }
        super.okPressed();
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        Button ok = this.getButton(0);
        ok.setText("OK");
        this.setButtonLayoutData(ok);
        ok.setEnabled(false);
    }

    protected Control createDialogArea(Composite parent) {
        super.createDialogArea(parent);
        Composite composite = new Composite(parent, 0);
        GridLayout la = new GridLayout();
        la.numColumns = 2;
        composite.setLayout((Layout)la);
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        Label l = new Label(composite, 0);
        l.setText("Metamodel URI:");
        this.cmbMetamodel = new Combo(composite, 8);
        List metamodels = this.hawkModel.getRegisteredMetamodels();
        Collections.sort(metamodels);
        for (String s : metamodels) {
            this.cmbMetamodel.add(s);
        }
        GridData data = new GridData(4, 1, true, false);
        this.cmbMetamodel.setLayoutData((Object)data);
        l = new Label(composite, 0);
        l.setText("Target Type:");
        this.cmbType = new Combo(composite, 2048);
        data = new GridData(4, 1, true, false);
        this.cmbType.setLayoutData((Object)data);
        this.cmbType.setText(DEFAULT_TYPE);
        l = new Label(composite, 0);
        l.setText("Property Name:");
        this.txtName = new Text(composite, 2048);
        data = new GridData(1, 1, true, false);
        data.minimumWidth = 200;
        this.txtName.setLayoutData((Object)data);
        this.txtName.setText(DEFAULT_NAME);
        l = new Label(composite, 0);
        l.setText("Attribute Type:");
        this.cmbValueType = new Combo(composite, 8);
        this.cmbValueType.add("String");
        this.cmbValueType.add("Integer");
        this.cmbValueType.add("Boolean");
        this.cmbValueType.add("TimelineAnnotation");
        this.cmbValueType.select(0);
        l = new Label(composite, 0);
        l.setText("isMany: ");
        this.cmbIsMany = new Combo(composite, 8);
        this.cmbIsMany.add("True");
        this.cmbIsMany.add("False");
        this.cmbIsMany.select(1);
        l = new Label(composite, 0);
        l.setText("isOrdered:");
        this.cmbIsOrdered = new Combo(composite, 8);
        this.cmbIsOrdered.add("True");
        this.cmbIsOrdered.add("False");
        this.cmbIsOrdered.select(1);
        l = new Label(composite, 0);
        l.setText("isUnique:");
        this.cmbIsUnique = new Combo(composite, 8);
        this.cmbIsUnique.add("True");
        this.cmbIsUnique.add("False");
        this.cmbIsUnique.select(1);
        l = new Label(composite, 0);
        l.setText("Derivation Language:");
        this.cmbDerivationLanguage = new Combo(composite, 8);
        for (String s : this.hawkModel.getKnownQueryLanguages()) {
            this.cmbDerivationLanguage.add(s);
        }
        this.cmbDerivationLanguage.select(0);
        l = new Label(composite, 0);
        l.setText("Derivation Logic:");
        this.txtDerivationLogic = new Text(composite, 2626);
        this.txtDerivationLogic.setText(DEFAULT_DERIVATION_LOGIC);
        data = new GridData(4, 1, true, false);
        data.minimumWidth = 200;
        data.widthHint = 225;
        data.heightHint = 150;
        data.verticalSpan = 2;
        this.txtDerivationLogic.setLayoutData((Object)data);
        Button btnLoadFromWorkspace = new Button(composite, 0);
        btnLoadFromWorkspace.setText("Load from workspace...");
        data = new GridData(131072, 1, false, false);
        data.horizontalSpan = 2;
        data.verticalSpan = 1;
        btnLoadFromWorkspace.setLayoutData((Object)data);
        btnLoadFromWorkspace.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                HDerivedAttributeDialog.this.loadLogicFromWorkspace();
            }
        });
        this.txtErrorMessages = new Text(composite, 66);
        data = new GridData(4, 1, true, false);
        data.horizontalSpan = 2;
        this.txtErrorMessages.setForeground(new Color((Device)this.getShell().getDisplay(), 255, 0, 0));
        this.txtErrorMessages.setBackground(composite.getBackground());
        FontData fd = this.txtErrorMessages.getFont().getFontData()[0];
        Font f = new Font((Device)composite.getDisplay(), fd.getName(), fd.getHeight() - 1, 0);
        this.txtErrorMessages.setFont(f);
        this.txtErrorMessages.setLayoutData((Object)data);
        this.txtErrorMessages.setText("");
        this.txtErrorMessages.setEditable(false);
        this.txtErrorMessages.setVisible(true);
        EvaluateSelectionListener selectionListener = new EvaluateSelectionListener();
        this.cmbMetamodel.addSelectionListener((SelectionListener)new TypeCascadeSelectionAdapter(this.hawkModel, this.cmbType));
        this.cmbMetamodel.addSelectionListener((SelectionListener)selectionListener);
        this.cmbType.addModifyListener(this::evaluateOKEnabled);
        this.txtName.addModifyListener(this::evaluateOKEnabled);
        this.cmbValueType.addSelectionListener((SelectionListener)selectionListener);
        this.cmbIsMany.addSelectionListener((SelectionListener)selectionListener);
        this.cmbIsOrdered.addSelectionListener((SelectionListener)selectionListener);
        this.cmbIsUnique.addSelectionListener((SelectionListener)selectionListener);
        this.cmbDerivationLanguage.addSelectionListener((SelectionListener)selectionListener);
        this.txtDerivationLogic.addModifyListener(this::evaluateOKEnabled);
        this.setTitle("Create derived attribute");
        this.setMessage("Specify the configuration of the new derived attribute.");
        return composite;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void loadLogicFromWorkspace() {
        StringBuilder sb;
        block16: {
            FilteredResourcesSelectionDialog dialog = new FilteredResourcesSelectionDialog(this.getShell(), false, (IContainer)ResourcesPlugin.getWorkspace().getRoot(), 1);
            dialog.setInitialPattern("*.eol");
            dialog.setTitle("Load derivation logic from workspace");
            dialog.setMessage("Select a script from the workspace");
            dialog.open();
            if (dialog.getReturnCode() != 0) return;
            IFile iFile = (IFile)dialog.getResult()[0];
            sb = new StringBuilder();
            try {
                Throwable throwable = null;
                Object var5_7 = null;
                try {
                    InputStreamReader isReader = new InputStreamReader(iFile.getContents(), iFile.getCharset());
                    try {
                        try (BufferedReader bR = new BufferedReader(isReader);){
                            String line;
                            while ((line = bR.readLine()) != null) {
                                sb.append(line);
                                sb.append(System.lineSeparator());
                            }
                        }
                        if (isReader == null) break block16;
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        if (isReader == null) throw throwable;
                        isReader.close();
                        throw throwable;
                    }
                    isReader.close();
                }
                catch (Throwable throwable3) {
                    if (throwable == null) {
                        throwable = throwable3;
                        throw throwable;
                    }
                    if (throwable == throwable3) throw throwable;
                    throwable.addSuppressed(throwable3);
                    throw throwable;
                }
            }
            catch (IOException | CoreException e) {
                Activator.logError(e.getMessage(), e);
            }
        }
        this.txtDerivationLogic.setText(sb.toString());
        this.evaluateOKEnabled();
    }

    private void evaluateOKEnabled(ModifyEvent e) {
        this.evaluateOKEnabled();
    }

    private void evaluateOKEnabled() {
        Button ok = this.getButton(0);
        if (this.check()) {
            this.enableIfRunning(this.hawkModel.getStatus());
        } else {
            ok.setEnabled(false);
        }
    }

    protected class EvaluateOKModifyListener
    implements ModifyListener {
        protected EvaluateOKModifyListener() {
        }

        public void modifyText(ModifyEvent e) {
            HDerivedAttributeDialog.this.evaluateOKEnabled();
        }
    }

    protected class EvaluateSelectionListener
    extends SelectionAdapter {
        protected EvaluateSelectionListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            HDerivedAttributeDialog.this.evaluateOKEnabled();
        }
    }
}

