/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hawk.timeaware.tests;

import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.NoSuchElementException;
import org.eclipse.hawk.backend.tests.LogbackOnlyErrorsRule;
import org.eclipse.hawk.backend.tests.RedirectSystemErrorRule;
import org.eclipse.hawk.backend.tests.TemporaryDatabaseTest;
import org.eclipse.hawk.backend.tests.factories.IGraphDatabaseFactory;
import org.eclipse.hawk.core.graph.IGraphEdge;
import org.eclipse.hawk.core.graph.IGraphIterable;
import org.eclipse.hawk.core.graph.IGraphNode;
import org.eclipse.hawk.core.graph.IGraphTransaction;
import org.eclipse.hawk.core.graph.timeaware.ITimeAwareGraphDatabase;
import org.eclipse.hawk.core.graph.timeaware.ITimeAwareGraphNode;
import org.eclipse.hawk.timeaware.tests.TimeAwareTestSuite;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class TimeAwareBackendTest
extends TemporaryDatabaseTest {
    private ITimeAwareGraphDatabase taDB;
    @Rule
    public RedirectSystemErrorRule errRule = new RedirectSystemErrorRule();
    @Rule
    public LogbackOnlyErrorsRule logRule = new LogbackOnlyErrorsRule();

    public TimeAwareBackendTest(File baseDir, IGraphDatabaseFactory dbf) {
        super(dbf);
    }

    @Parameterized.Parameters(name="{1}")
    public static Iterable<Object[]> params() {
        return TimeAwareTestSuite.caseParams();
    }

    public void setup() throws Exception {
        super.setup();
        this.taDB = (ITimeAwareGraphDatabase)this.db;
    }

    @Test
    public void indexQueryEndedNodes() throws Exception {
        IGraphIterable iterable;
        Object nodeId;
        IGraphTransaction tx;
        Throwable throwable = null;
        Object var3_7 = null;
        try {
            tx = this.db.beginTransaction();
            try {
                IGraphNode n1T0 = this.db.createNode(Collections.singletonMap("x", 1), "test");
                this.db.getMetamodelIndex().add(n1T0, Collections.singletonMap("key", "foo"));
                nodeId = n1T0.getId();
                tx.success();
            }
            finally {
                if (tx != null) {
                    tx.close();
                }
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        throwable = null;
        var3_7 = null;
        try {
            tx = this.db.beginTransaction();
            try {
                iterable = this.db.getMetamodelIndex().query("key", (Object)"foo");
                Assert.assertEquals((long)1L, (long)iterable.size());
                Assert.assertEquals((Object)nodeId, (Object)((IGraphNode)iterable.getSingle()).getId());
                Assert.assertTrue((boolean)iterable.iterator().hasNext());
                tx.success();
            }
            finally {
                if (tx != null) {
                    tx.close();
                }
            }
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
            } else if (throwable != throwable3) {
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
        this.taDB.setTime(1L);
        throwable = null;
        var3_7 = null;
        try {
            tx = this.db.beginTransaction();
            try {
                IGraphNode n1T1 = this.db.getNodeById(nodeId);
                ((ITimeAwareGraphNode)n1T1).end();
                IGraphIterable iterable2 = this.db.getMetamodelIndex().query("key", (Object)"foo");
                Assert.assertEquals((long)1L, (long)iterable2.size());
                Assert.assertEquals((Object)nodeId, (Object)((IGraphNode)iterable2.getSingle()).getId());
                Assert.assertTrue((boolean)iterable2.iterator().hasNext());
                tx.success();
            }
            finally {
                if (tx != null) {
                    tx.close();
                }
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
        this.taDB.setTime(2L);
        throwable = null;
        var3_7 = null;
        try {
            tx = this.db.beginTransaction();
            try {
                iterable = this.db.getMetamodelIndex().query("key", (Object)"foo");
                Assert.assertEquals((long)0L, (long)iterable.size());
                Assert.assertFalse((boolean)iterable.iterator().hasNext());
                try {
                    iterable.getSingle();
                    Assert.fail((String)"Should throw a NoSuchElementException");
                }
                catch (NoSuchElementException noSuchElementException) {
                    // empty catch block
                }
                tx.success();
            }
            finally {
                if (tx != null) {
                    tx.close();
                }
            }
        }
        catch (Throwable throwable5) {
            if (throwable == null) {
                throwable = throwable5;
            } else if (throwable != throwable5) {
                throwable.addSuppressed(throwable5);
            }
            throw throwable;
        }
        this.taDB.setTime(0L);
        throwable = null;
        var3_7 = null;
        try {
            tx = this.db.beginTransaction();
            try {
                iterable = this.db.getMetamodelIndex().query("key", (Object)"foo");
                Assert.assertEquals((long)1L, (long)iterable.size());
                Assert.assertEquals((Object)nodeId, (Object)((IGraphNode)iterable.getSingle()).getId());
                Assert.assertTrue((boolean)iterable.iterator().hasNext());
                tx.success();
            }
            finally {
                if (tx != null) {
                    tx.close();
                }
            }
        }
        catch (Throwable throwable6) {
            if (throwable == null) {
                throwable = throwable6;
            } else if (throwable != throwable6) {
                throwable.addSuppressed(throwable6);
            }
            throw throwable;
        }
    }

    @Test
    public void indexQueryReplacedNodes() throws Exception {
        Object nodeId;
        IGraphTransaction tx;
        Throwable throwable = null;
        Object var3_5 = null;
        try {
            tx = this.db.beginTransaction();
            try {
                IGraphNode n1 = this.db.createNode(Collections.emptyMap(), "test");
                nodeId = n1.getId();
                this.db.getMetamodelIndex().add(n1, Collections.singletonMap("file", "abc.xmi"));
                tx.success();
            }
            finally {
                if (tx != null) {
                    tx.close();
                }
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        this.taDB.setTime(1L);
        throwable = null;
        var3_5 = null;
        try {
            tx = this.db.beginTransaction();
            try {
                this.taDB.getNodeById(nodeId).end();
                tx.success();
            }
            finally {
                if (tx != null) {
                    tx.close();
                }
            }
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
            } else if (throwable != throwable3) {
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
        this.taDB.setTime(2L);
        throwable = null;
        var3_5 = null;
        try {
            tx = this.db.beginTransaction();
            try {
                IGraphNode n2 = this.db.createNode(Collections.emptyMap(), "test");
                this.db.getMetamodelIndex().add(n2, Collections.singletonMap("file", "abc.xmi"));
                nodeId = n2.getId();
                IGraphIterable iterable = this.db.getMetamodelIndex().query("file", (Object)"abc.xmi");
                Assert.assertEquals((long)1L, (long)iterable.size());
                Assert.assertEquals((Object)nodeId, (Object)((IGraphNode)iterable.iterator().next()).getId());
                Assert.assertEquals((Object)nodeId, (Object)((IGraphNode)iterable.getSingle()).getId());
                tx.success();
            }
            finally {
                if (tx != null) {
                    tx.close();
                }
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
    }

    @Test
    public void nodeEndWithLightEdge() throws Exception {
        this.nodeEndWithEdges(Collections.emptyMap());
    }

    @Test
    public void nodeEndWithHeavyEdge() throws Exception {
        this.nodeEndWithEdges(Collections.singletonMap("container", "true"));
    }

    private void nodeEndWithEdges(Map<String, Object> props) throws Exception {
        Object id2;
        Object id1;
        IGraphNode n2;
        IGraphNode n1;
        IGraphTransaction tx;
        Throwable throwable = null;
        Object var5_8 = null;
        try {
            tx = this.db.beginTransaction();
            try {
                n1 = this.db.createNode(null, "example");
                n2 = this.db.createNode(null, "example");
                this.db.createRelationship(n1, n2, "test", props);
                id1 = n1.getId();
                id2 = n2.getId();
                tx.success();
            }
            finally {
                if (tx != null) {
                    tx.close();
                }
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        this.taDB.setTime(1L);
        throwable = null;
        var5_8 = null;
        try {
            tx = this.db.beginTransaction();
            try {
                n1 = this.taDB.getNodeById(id1);
                n2 = this.taDB.getNodeById(id2);
                Assert.assertTrue((boolean)n1.getOutgoing().iterator().hasNext());
                Assert.assertTrue((boolean)n2.getIncoming().iterator().hasNext());
                n2.end();
                tx.success();
            }
            finally {
                if (tx != null) {
                    tx.close();
                }
            }
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
            } else if (throwable != throwable3) {
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
        throwable = null;
        var5_8 = null;
        try {
            tx = this.db.beginTransaction();
            try {
                n1 = this.taDB.getNodeById(id1);
                n2 = this.taDB.getNodeById(id2);
                Assert.assertTrue((boolean)n1.getOutgoing().iterator().hasNext());
                Assert.assertTrue((boolean)n2.getIncoming().iterator().hasNext());
                tx.success();
            }
            finally {
                if (tx != null) {
                    tx.close();
                }
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
        this.taDB.setTime(0L);
        throwable = null;
        var5_8 = null;
        try {
            tx = this.db.beginTransaction();
            try {
                n1 = this.taDB.getNodeById(id1);
                n2 = this.taDB.getNodeById(id2);
                Assert.assertTrue((boolean)n1.getOutgoing().iterator().hasNext());
                Assert.assertTrue((boolean)n2.getIncoming().iterator().hasNext());
                tx.success();
            }
            finally {
                if (tx != null) {
                    tx.close();
                }
            }
        }
        catch (Throwable throwable5) {
            if (throwable == null) {
                throwable = throwable5;
            } else if (throwable != throwable5) {
                throwable.addSuppressed(throwable5);
            }
            throw throwable;
        }
        this.taDB.setTime(2L);
        throwable = null;
        var5_8 = null;
        try {
            tx = this.db.beginTransaction();
            try {
                n1 = this.taDB.getNodeById(id1);
                n2 = this.taDB.getNodeById(id2);
                Assert.assertFalse((boolean)n1.getOutgoing().iterator().hasNext());
                Assert.assertFalse((boolean)n2.isAlive());
                tx.success();
            }
            finally {
                if (tx != null) {
                    tx.close();
                }
            }
        }
        catch (Throwable throwable6) {
            if (throwable == null) {
                throwable = throwable6;
            } else if (throwable != throwable6) {
                throwable.addSuppressed(throwable6);
            }
            throw throwable;
        }
    }

    @Test
    public void createDeleteHeavyEdgeBeginningOfTime() throws Exception {
        this.taDB.setTime(0L);
        this.createDeleteHeavyEdge();
    }

    @Test
    public void createDeleteHeavyEdgeNonZeroTime() throws Exception {
        this.taDB.setTime(1L);
        this.createDeleteHeavyEdge();
    }

    @Test
    public void nextPrev() throws Exception {
        ITimeAwareGraphNode n;
        IGraphTransaction tx;
        Throwable throwable = null;
        Object var3_6 = null;
        try {
            tx = this.db.beginTransaction();
            try {
                this.taDB.setTime(9L);
                n = this.taDB.createNode(Collections.singletonMap("x", 1), "example");
                tx.success();
            }
            finally {
                if (tx != null) {
                    tx.close();
                }
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        throwable = null;
        var3_6 = null;
        try {
            tx = this.db.beginTransaction();
            try {
                n.travelInTime(10L).setProperty("x", (Object)3);
                tx.success();
            }
            finally {
                if (tx != null) {
                    tx.close();
                }
            }
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
            } else if (throwable != throwable3) {
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
        throwable = null;
        var3_6 = null;
        try {
            tx = this.db.beginTransaction();
            try {
                n.travelInTime(11L).setProperty("x", (Object)5);
                tx.success();
            }
            finally {
                if (tx != null) {
                    tx.close();
                }
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
        throwable = null;
        var3_6 = null;
        try {
            tx = this.db.beginTransaction();
            try {
                Assert.assertEquals(Arrays.asList(11L, 10L, 9L), (Object)n.getAllInstants());
                Assert.assertEquals((long)10L, (long)n.travelInTime(9L).getNextInstant());
                Assert.assertEquals((long)11L, (long)n.travelInTime(10L).getNextInstant());
                Assert.assertEquals((long)-1L, (long)n.travelInTime(11L).getNextInstant());
                Assert.assertEquals((long)-1L, (long)n.travelInTime(9L).getPreviousInstant());
                Assert.assertEquals((long)9L, (long)n.travelInTime(10L).getPreviousInstant());
                Assert.assertEquals((long)10L, (long)n.travelInTime(11L).getPreviousInstant());
            }
            finally {
                if (tx != null) {
                    tx.close();
                }
            }
        }
        catch (Throwable throwable5) {
            if (throwable == null) {
                throwable = throwable5;
            } else if (throwable != throwable5) {
                throwable.addSuppressed(throwable5);
            }
            throw throwable;
        }
    }

    private void createDeleteHeavyEdge() throws Exception {
        Object heavyEdgeId;
        IGraphTransaction tx;
        Throwable throwable = null;
        Object var3_4 = null;
        try {
            tx = this.db.beginTransaction();
            try {
                IGraphNode n1 = this.db.createNode(null, "example");
                IGraphNode n2 = this.db.createNode(null, "example");
                IGraphEdge e = this.db.createRelationship(n1, n2, "example", Collections.singletonMap("key", "value"));
                heavyEdgeId = e.getId();
                e.delete();
                tx.success();
            }
            finally {
                if (tx != null) {
                    tx.close();
                }
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        throwable = null;
        var3_4 = null;
        try {
            tx = this.db.beginTransaction();
            try {
                ITimeAwareGraphNode backingNode = this.taDB.getNodeById(heavyEdgeId);
                Assert.assertFalse((boolean)backingNode.isAlive());
                tx.success();
            }
            finally {
                if (tx != null) {
                    tx.close();
                }
            }
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
            } else if (throwable != throwable3) {
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    }
}

