/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hawk.integration.tests.modelio;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.eclipse.hawk.backend.tests.factories.IGraphDatabaseFactory;
import org.eclipse.hawk.core.graph.IGraphDatabase;
import org.eclipse.hawk.core.graph.IGraphNodeIndex;
import org.eclipse.hawk.core.graph.IGraphTransaction;
import org.eclipse.hawk.graph.ProxyReferenceList;
import org.eclipse.hawk.graph.updater.GraphModelUpdater;
import org.eclipse.hawk.integration.tests.IntegrationTestSuite;
import org.eclipse.hawk.integration.tests.ModelIndexingTest;
import org.eclipse.hawk.integration.tests.modelio.ModelioModelSupportFactory;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.junit.runners.Parameterized;

public class ModelioProxyResolutionTest
extends ModelIndexingTest {
    private static final String PACKAGE_FRAGMENT = "ea878bd2-7ef9-4ce1-a11e-35fa129981bb";
    private static final String ANIMAL_FRAGMENT = "4ed7f59f-f723-4f88-b6fc-ea6b83eb3108";
    private static final String STRING_FRAGMENT = "00000004-0000-000d-0000-000000000000";
    private final Path zooModel;
    private static final Map<String, String> CLASS_TO_FRAGMENT = new HashMap<String, String>();
    @Rule
    public TemporaryFolder tempModelFolder;
    private GraphModelUpdater updater;

    static {
        CLASS_TO_FRAGMENT.put("Animal", ANIMAL_FRAGMENT);
        CLASS_TO_FRAGMENT.put("Area", "0a4ac84f-75a3-4b5b-bbad-d0e67857b4cf");
        CLASS_TO_FRAGMENT.put("Elephant", "2d7b2cba-e694-4b33-bd9e-4d2f1db4cc7b");
        CLASS_TO_FRAGMENT.put("Lion", "c312e899-9f08-43db-8954-4db87789f843");
        CLASS_TO_FRAGMENT.put("Zebra", "9b9791e8-8e77-4fd0-ada7-e62bdfad9ec4");
        CLASS_TO_FRAGMENT.put("Zoo", "4b6abbc6-130e-42fa-b1db-bbf1ba6d0065");
    }

    @Parameterized.Parameters(name="{1}")
    public static Iterable<Object[]> params() {
        return IntegrationTestSuite.caseParams();
    }

    public ModelioProxyResolutionTest(File baseDir, IGraphDatabaseFactory dbf) {
        super(baseDir, dbf, new ModelioModelSupportFactory());
        this.zooModel = Paths.get(this.baseDir.getPath(), "resources", "models", "zoo", "data", "fragments", "Zoo", "model");
        this.tempModelFolder = new TemporaryFolder();
    }

    @Override
    public void setup() throws Throwable {
        super.setup();
        this.indexer.registerMetamodels(new File[]{new File(new File(this.baseDir, "resources/metamodels/"), "metamodel_descriptor.xml")});
        this.updater = (GraphModelUpdater)this.indexer.getModelUpdaters().iterator().next();
    }

    @Test
    public void elephantResolve() throws Throwable {
        this.copyClasses("Elephant");
        this.requestFolderIndex(this.tempModelFolder.getRoot());
        this.scheduleAndWait(() -> {
            Throwable throwable = null;
            Object var2_3 = null;
            try (IGraphTransaction tx = this.db.beginTransaction();){
                IGraphNodeIndex fragmentIndex = this.db.getOrCreateNodeIndex("fragmentdictionary");
                Assert.assertEquals((long)3L, (long)fragmentIndex.query("id", (Object)"*").size());
                this.updater.createInserter();
                List lists = ProxyReferenceList.getLists((IGraphDatabase)this.indexer.getGraph());
                Assert.assertEquals((long)2L, (long)lists.size());
                Set<String> unresolved = this.collectUnresolvedFragments(lists);
                Assert.assertEquals(new HashSet<String>(Arrays.asList(PACKAGE_FRAGMENT, ANIMAL_FRAGMENT)), unresolved);
                tx.success();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            return null;
        });
        this.copyClasses("Animal", "Area");
        this.indexer.requestImmediateSync();
        this.scheduleAndWait(() -> {
            List lists = ProxyReferenceList.getLists((IGraphDatabase)this.indexer.getGraph());
            Assert.assertEquals((long)5L, (long)lists.size());
            Set<String> unresolved = this.collectUnresolvedFragments(lists);
            Assert.assertEquals(new HashSet<String>(Arrays.asList(STRING_FRAGMENT, PACKAGE_FRAGMENT)), unresolved);
            return null;
        });
    }

    @Test
    public void zoo() throws Throwable {
        this.requestFolderIndex(new File("resources/models/zoo"));
        this.scheduleAndWait(() -> {
            List lists = ProxyReferenceList.getLists((IGraphDatabase)this.indexer.getGraph());
            Set<String> unresolved = this.collectUnresolvedFragments(lists);
            Assert.assertEquals(Collections.emptySet(), unresolved);
            return null;
        });
    }

    private Set<String> collectUnresolvedFragments(List<ProxyReferenceList> lists) {
        HashSet<String> unresolved = new HashSet<String>();
        for (ProxyReferenceList list : lists) {
            Assert.assertTrue((boolean)list.getTargetFile().isFragmentBased());
            for (ProxyReferenceList.ProxyReference ref : list.getReferences()) {
                Assert.assertTrue((boolean)ref.getTarget().isFragmentBased());
                unresolved.add(ref.getTarget().getFragment());
            }
        }
        return unresolved;
    }

    private void printProxyRefs(List<ProxyReferenceList> lists) {
        for (ProxyReferenceList list : lists) {
            System.out.println("----");
            System.out.println("Source: " + list.getSourceNodeID());
            System.out.println("Target file: " + list.getTargetFile());
            for (ProxyReferenceList.ProxyReference ref : list.getReferences()) {
                System.out.println("* " + ref);
            }
        }
    }

    private void copyClasses(String ... classes) throws IOException {
        String[] stringArray = classes;
        int n = classes.length;
        int n2 = 0;
        while (n2 < n) {
            String klass = stringArray[n2];
            FileUtils.copyFileToDirectory((File)this.getClass(klass), (File)this.tempModelFolder.getRoot());
            ++n2;
        }
    }

    private File getClass(String klass) {
        return this.getFragmentFile("Class", CLASS_TO_FRAGMENT.get(klass));
    }

    private File getFragmentFile(String type, String fragment) {
        if (fragment == null) {
            throw new NoSuchElementException();
        }
        return this.zooModel.resolve(Paths.get("Standard." + type, String.valueOf(fragment) + ".exml")).toFile();
    }
}

