/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hawk.integration.tests.emf;

import java.io.File;
import org.eclipse.hawk.backend.tests.factories.IGraphDatabaseFactory;
import org.eclipse.hawk.epsilon.emc.optimisation.OptimisableCollection;
import org.eclipse.hawk.integration.tests.IntegrationTestSuite;
import org.eclipse.hawk.integration.tests.ModelIndexingTest;
import org.eclipse.hawk.integration.tests.emf.EMFModelSupportFactory;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runners.Parameterized;

public class IndexedAttributeTest
extends ModelIndexingTest {
    @Parameterized.Parameters(name="{1}")
    public static Iterable<Object[]> params() {
        return IntegrationTestSuite.caseParams();
    }

    public IndexedAttributeTest(File baseDir, IGraphDatabaseFactory dbf) {
        super(baseDir, dbf, new EMFModelSupportFactory());
    }

    @Test
    public void lookupWithIndex() throws Throwable {
        this.indexer.registerMetamodels(new File[]{new File(this.baseDir, "resources/metamodels/Ecore.ecore"), new File(this.baseDir, "resources/metamodels/crossrefs.ecore")});
        this.indexer.addIndexedAttribute("http://github.com/mondo-hawk/testing/xrefs", "Element", "id");
        this.requestFolderIndex(new File(this.baseDir, "resources/models/scopedQuery"));
        this.scheduleAndWait(() -> {
            Assert.assertEquals((Object)OptimisableCollection.class.getSimpleName(), (Object)this.eol("return Element.all.class.simpleName;"));
            Assert.assertEquals((Object)1, (Object)this.eol("return Element.all.select(e|e.id=1).size();"));
            return null;
        });
    }

    @Test
    public void addThenIndex() throws Throwable {
        this.indexer.registerMetamodels(new File[]{new File(this.baseDir, "resources/metamodels/Ecore.ecore"), new File(this.baseDir, "resources/metamodels/crossrefs.ecore")});
        this.requestFolderIndex(new File(this.baseDir, "resources/models/scopedQuery"));
        this.indexer.addIndexedAttribute("http://github.com/mondo-hawk/testing/xrefs", "Element", "id");
        this.scheduleAndWait(() -> {
            Assert.assertEquals((Object)OptimisableCollection.class.getSimpleName(), (Object)this.eol("return Element.all.class.simpleName;"));
            Assert.assertEquals((Object)1, (Object)this.eol("return Element.all.select(e|e.id=1).size();"));
            return null;
        });
    }

    @Test
    public void lookupWithoutIndex() throws Throwable {
        this.indexer.registerMetamodels(new File[]{new File(this.baseDir, "resources/metamodels/Ecore.ecore"), new File(this.baseDir, "resources/metamodels/crossrefs.ecore")});
        this.requestFolderIndex(new File(this.baseDir, "resources/models/scopedQuery"));
        this.scheduleAndWait(() -> {
            Assert.assertNotEquals((Object)OptimisableCollection.class.getSimpleName(), (Object)this.eol("return Element.all.class.simpleName;"));
            Assert.assertEquals((Object)1, (Object)this.eol("return Element.all.select(e|e.id=1).size();"));
            return null;
        });
    }
}

