/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hawk.integration.tests.emf;

import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.hawk.backend.tests.factories.IGraphDatabaseFactory;
import org.eclipse.hawk.integration.tests.IntegrationTestSuite;
import org.eclipse.hawk.integration.tests.ModelIndexingTest;
import org.eclipse.hawk.integration.tests.emf.EMFModelSupportFactory;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runners.Parameterized;

public class DerivedFeatureTest
extends ModelIndexingTest {
    @Parameterized.Parameters(name="{1}")
    public static Iterable<Object[]> params() {
        return IntegrationTestSuite.caseParams();
    }

    public DerivedFeatureTest(File baseDir, IGraphDatabaseFactory dbf) {
        super(baseDir, dbf, new EMFModelSupportFactory());
    }

    @Test
    public void derivedEdgeCollection() throws Throwable {
        this.indexer.registerMetamodels(new File[]{new File(this.baseDir, "resources/metamodels/Ecore.ecore"), new File(this.baseDir, "resources/metamodels/Tree.ecore")});
        this.requestFolderIndex(new File(this.baseDir, "resources/models/tree-dedges"));
        this.scheduleAndWait(() -> {
            Object result;
            Map<String, Object> context;
            this.indexer.addDerivedAttribute("Tree", "Tree", "descendants", "dummy", true, true, false, "org.eclipse.hawk.epsilon.emc.EOLQueryEngine", "return self.closure(c|c.children).flatten;");
            Object expected = new HashMap<String, Integer>();
            expected.put("t3", 3);
            expected.put("t4", 1);
            expected.put("t5", 0);
            expected.put("t6", 0);
            for (Map.Entry entry : expected.entrySet()) {
                context = Collections.singletonMap("ARGUMENTS", Collections.singletonMap("nodeLabel", (String)entry.getKey()));
                result = this.eol("return Tree.all.selectOne(t|t.label=nodeLabel).descendants.size;", context);
                Assert.assertEquals((String)String.format("%s should have %d descendants", entry.getKey(), entry.getValue()), entry.getValue(), (Object)result);
            }
            HashMap<String, Integer> reverseExpected = new HashMap<String, Integer>();
            reverseExpected.put("t3", 0);
            reverseExpected.put("t4", 1);
            reverseExpected.put("t5", 1);
            reverseExpected.put("t6", 2);
            for (Map.Entry entry : reverseExpected.entrySet()) {
                context = Collections.singletonMap("ARGUMENTS", Collections.singletonMap("nodeLabel", (String)entry.getKey()));
                result = this.eol("return Tree.all.selectOne(t|t.label=nodeLabel).revRefNav_descendants.size;", context);
                Assert.assertEquals((String)String.format("%s should have %d ancestors", entry.getKey(), entry.getValue()), entry.getValue(), (Object)result);
            }
            expected = Arrays.asList("t3", "t4");
            Collection result2 = (Collection)this.eol("return Tree.all.selectOne(t|t.label='t6').revRefNav_descendants.label.flatten;");
            Assert.assertEquals((long)expected.size(), (long)result2.size());
            Iterator iterator = expected.iterator();
            while (iterator.hasNext()) {
                String e = (String)iterator.next();
                Assert.assertTrue((boolean)result2.contains(e));
            }
            return null;
        });
    }

    @Test
    public void derivedEdgeSingle() throws Throwable {
        this.indexer.registerMetamodels(new File[]{new File(this.baseDir, "resources/metamodels/Ecore.ecore"), new File(this.baseDir, "resources/metamodels/Tree.ecore")});
        this.requestFolderIndex(new File(this.baseDir, "resources/models/tree-dedges"));
        this.scheduleAndWait(() -> {
            this.indexer.addDerivedAttribute("Tree", "Tree", "maxDescendant", "dummy", false, true, false, "org.eclipse.hawk.epsilon.emc.EOLQueryEngine", "return self.closure(c|c.children).flatten.sortBy(t|t.label).last;");
            Object result = this.eol("return Tree.all.selectOne(t|t.label='t3').maxDescendant.first.label;");
            Assert.assertEquals((Object)"t6", (Object)result);
            HashMap<String, Integer> reverseExpected = new HashMap<String, Integer>();
            reverseExpected.put("t3", 0);
            reverseExpected.put("t4", 0);
            reverseExpected.put("t5", 0);
            reverseExpected.put("t6", 2);
            for (Map.Entry entry : reverseExpected.entrySet()) {
                Map<String, Object> context = Collections.singletonMap("ARGUMENTS", Collections.singletonMap("nodeLabel", (String)entry.getKey()));
                Object result2 = this.eol("return Tree.all.selectOne(t|t.label=nodeLabel).revRefNav_maxDescendant.size;", context);
                Assert.assertEquals((String)String.format("%s should have %d maxDescendant reverse refs", entry.getKey(), entry.getValue()), entry.getValue(), (Object)result2);
            }
            return null;
        });
    }

    @Test
    public void deriveThenAdd() throws Throwable {
        this.indexer.registerMetamodels(new File[]{new File(this.baseDir, "resources/metamodels/Ecore.ecore"), new File(this.baseDir, "resources/metamodels/crossrefs.ecore")});
        this.indexer.addDerivedAttribute("http://github.com/mondo-hawk/testing/xrefs", "Element", "nRefs", "dummy", false, true, false, "org.eclipse.hawk.epsilon.emc.EOLQueryEngine", "return self.xrefs.size;");
        this.requestFolderIndex(new File(this.baseDir, "resources/models/scopedQuery"));
        this.scheduleAndWait(() -> {
            Assert.assertEquals((Object)1, (Object)this.eol("return Element.all.selectOne(e|e.id=0).nRefs;"));
            Assert.assertEquals((Object)3, (Object)this.eol("return Element.all.selectOne(e|e.id=1).nRefs;"));
            Assert.assertEquals((Object)3, (Object)this.eol("return Element.all.selectOne(e|e.id=23).nRefs;"));
            return null;
        });
    }
}

