/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.comma.monitoring.lib;

import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.comma.monitoring.lib.CCoverageInfo;
import org.eclipse.comma.monitoring.lib.CError;
import org.eclipse.comma.monitoring.lib.CInterfaceMonitoringContext;
import org.eclipse.comma.monitoring.lib.CMonitorResults;
import org.eclipse.comma.monitoring.lib.CState;
import org.eclipse.comma.monitoring.lib.constraints.CRuleError;
import org.eclipse.comma.monitoring.lib.utils.StringBuilder2;

public class CConnectionResults
extends CMonitorResults {
    private List<CState> executionStates;
    private CInterfaceMonitoringContext context;
    @Expose
    private String connectionName;
    @Expose
    private String status;
    @Expose
    private List<CError> monitoringErrors;
    @Expose
    @SerializedName(value="warnings")
    private List<CRuleError> constraintErrors;

    public CConnectionResults(CInterfaceMonitoringContext context) {
        this.context = context;
        this.connectionName = context.getConnectionName();
        this.monitoringErrors = new ArrayList<CError>();
        this.constraintErrors = new ArrayList<CRuleError>();
        this.executionStates = new ArrayList<CState>();
        this.resultsFolder = context.resultsDir();
    }

    public CInterfaceMonitoringContext getContext() {
        return this.context;
    }

    public void addMonitoringError(CError error) {
        this.monitoringErrors.add(error);
    }

    public List<CError> getMonitoringErrors() {
        return this.monitoringErrors;
    }

    public void addConstraintErrors(List<CRuleError> errors) {
        this.constraintErrors.addAll(errors);
    }

    public List<CRuleError> getConstraintErrors() {
        return this.constraintErrors;
    }

    public void addExecutionState(CState s) {
        this.executionStates.add(s);
        CCoverageInfo ci = s.getCoverageInfo();
        ci.setInterfaceName(this.context.getInterfaceName());
        ci.calculateCoveragePercentage();
        this.coverageInfo.add(ci);
    }

    public boolean isSuccess() {
        boolean noErrors = this.monitoringErrors.isEmpty();
        if (noErrors) {
            this.status = "successful";
            return noErrors;
        }
        this.status = "failed";
        return noErrors;
    }

    public String toString() {
        StringBuilder2 builder = new StringBuilder2();
        if (this.isSuccess()) {
            builder.append("Success: no errors found.");
            builder.newLine();
            builder.newLine();
        } else {
            for (CError cError : this.monitoringErrors) {
                builder.append(cError.toString());
                builder.newLine();
            }
        }
        for (CRuleError cRuleError : this.constraintErrors) {
            builder.append(cRuleError.toString());
            builder.newLine();
            builder.newLine();
        }
        for (CState cState : this.executionStates) {
            builder.append("Coverage Info");
            builder.newLine();
            builder.append("=================================");
            builder.newLine();
            builder.append(cState.coverageInfoToString());
        }
        return builder.toString();
    }
}

