use utf8;

package SemanticWeb::Schema::DayOfWeek;

# ABSTRACT: The day of the week, e

use Moo;

extends qw/ SemanticWeb::Schema::Enumeration /;


use MooX::JSON_LD 'DayOfWeek';
use Ref::Util qw/ is_plain_hashref /;
# RECOMMEND PREREQ: Ref::Util::XS

use namespace::autoclean;

our $VERSION = 'v15.0.0';




1;

__END__

=pod

=encoding UTF-8

=head1 NAME

SemanticWeb::Schema::DayOfWeek - The day of the week, e

=head1 VERSION

version v15.0.0

=head1 DESCRIPTION

The day of the week, e.g. used to specify to which day the opening hours of an OpeningHoursSpecification refer.

Originally, URLs from L<GoodRelations|http://purl.org/goodrelations/v1> were used (for L<SemanticWeb::Schema::Monday>, L<SemanticWeb::Schema::Tuesday>, L<SemanticWeb::Schema::Wednesday>, L<SemanticWeb::Schema::Thursday>, L<SemanticWeb::Schema::Friday>, L<SemanticWeb::Schema::Saturday>, L<SemanticWeb::Schema::Sunday> plus a special entry for L<SemanticWeb::Schema::PublicHolidays>); these have now been integrated directly into schema.org.

=head1 SEE ALSO

L<SemanticWeb::Schema::Enumeration>

=head1 SOURCE

The development version is on github at L<https://github.com/robrwo/SemanticWeb-Schema>
and may be cloned from L<git://github.com/robrwo/SemanticWeb-Schema.git>

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website
L<https://github.com/robrwo/SemanticWeb-Schema/issues>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 AUTHOR

Robert Rothenberg <rrwo@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is Copyright (c) 2018-2022 by Robert Rothenberg.

This is free software, licensed under:

  The Artistic License 2.0 (GPL Compatible)

=cut
