package Net::Async::Spotify::API::Generated::Personalization;

use strict;
use warnings;

our $VERSION = '0.001'; # VERSION
our $AUTHORITY = 'cpan:VNEALV'; # AUTHORITY

use mro;
use parent qw(Net::Async::Spotify::API::Base);

use Future::AsyncAwait;

=encoding utf8

=head1 NAME

Net::Async::Spotify::API::Generated::Personalization - Package representing Spotify Personalization API

=head1 DESCRIPTION

Autogenerated module.
Based on https://developer.spotify.com/documentation/web-api/reference/#reference-index
Check C<crawl-api-doc.pl> for more information.

=head1 METHODS

=cut

=head2 get_users_top_artists_and_tracks

get_users_top_artists_and_tracks - Get a User's Top Artists and Tracks

Get the current user’s top artists or tracks based on calculated affinity.

with Request details being:

=head3 header

=over 4

=item Authorization

Type: string | Required: required
A valid access token from the Spotify Accounts service: see the Web API Authorization Guide for details. The access token must have been issued on behalf of the current user.Getting details of a user’s top artists and tracks requires authorization of the user-top-read scope. See Using Scopes.

=back

=head3 path_parameter

=over 4

=item type

Type: string | Required: required
The type of entity to return. Valid values: artists or tracks

=back

=head3 query_parameter

=over 4

=item limit

Type: integer | Required: optional
The number of entities to return. Default: 20. Minimum: 1. Maximum: 50. For example: limit=2

=item offset

Type: integer | Required: optional
The index of the first entity to return. Default: 0 (i.e., the first track). Use with limit to get the next set of entities.

=item time_range

Type: string | Required: optional
Over what time frame the affinities are computed. Valid values: long_term (calculated from several years of data and including all new data as it becomes available), medium_term (approximately last 6 months), short_term (approximately last 4 weeks). Default: medium_term

=back

and Response Objects being:

- paging object


On success, the HTTP status code in the response header is 200 OK and the response body contains a paging object of Artists or Tracks. On error, the header status code is an error code and the response body contains an error object.Try in our Web Console

=cut

async sub get_users_top_artists_and_tracks {
    my ($self, %args) = @_;

    my $request->{method} = 'GET';
    $request->{uri}    = 'https://api.spotify.com/v1/me/top/{type}';
    $request->{param}  = {
        header => {
            'Authorization' => {
                type     => 'string',
                required => 'required',
            },
        },
        path_parameter => {
            'type' => {
                type     => 'string',
                required => 'required',
            },
        },
        query_parameter => {
            'limit' => {
                type     => 'integer',
                required => 'optional',
            },
            'offset' => {
                type     => 'integer',
                required => 'optional',
            },
            'time_range' => {
                type     => 'string',
                required => 'optional',
            },
        },
    };
    my $response_objs = [
        'paging object',

    ];

    await $self->call_api($request, $response_objs, %args);
}

1;
